/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher;

import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.server.http.cypher.TransactionHandle;
import org.neo4j.server.http.cypher.TransactionLifecycleException;
import org.neo4j.server.http.cypher.TransactionRegistry;
import org.neo4j.server.http.cypher.format.api.TransactionUriScheme;

class TransactionFacade {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(TransactionFacade.class);
    private final GraphDatabaseAPI databaseAPI;
    private final QueryExecutionEngine engine;
    private final TransactionRegistry registry;

    TransactionFacade(GraphDatabaseAPI databaseAPI, QueryExecutionEngine engine, TransactionRegistry registry) {
        this.databaseAPI = databaseAPI;
        this.engine = engine;
        this.registry = registry;
    }

    TransactionHandle newTransactionHandle(TransactionUriScheme uriScheme, boolean implicitTransaction, LoginContext loginContext, ClientConnectionInfo connectionInfo, MemoryTracker memoryTracker, long customTransactionTimeout) {
        memoryTracker.allocateHeap(TransactionHandle.SHALLOW_SIZE);
        return new TransactionHandle(this.databaseAPI, this.engine, this.registry, uriScheme, implicitTransaction, loginContext, connectionInfo, customTransactionTimeout);
    }

    TransactionHandle findTransactionHandle(long txId, LoginContext requestingUser) throws TransactionLifecycleException {
        return this.registry.acquire(txId, requestingUser);
    }

    TransactionHandle terminate(long txId, LoginContext loginContext) throws TransactionLifecycleException {
        return this.registry.terminate(txId, loginContext);
    }
}

