/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher;

import java.time.Clock;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.neo4j.common.DependencyResolver;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.MemoryPool;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.server.http.cypher.TransactionFacade;
import org.neo4j.server.http.cypher.TransactionHandleRegistry;
import org.neo4j.server.http.cypher.TransactionRegistry;
import org.neo4j.time.Clocks;

public class HttpTransactionManager {
    private final TransactionRegistry transactionRegistry;
    private final DatabaseManagementService managementService;
    private final JobScheduler jobScheduler;

    public HttpTransactionManager(DatabaseManagementService managementService, MemoryPool memoryPool, JobScheduler jobScheduler, Clock clock, Duration transactionTimeout, LogProvider userLogProvider) {
        this.managementService = managementService;
        this.jobScheduler = jobScheduler;
        this.transactionRegistry = new TransactionHandleRegistry(clock, transactionTimeout, userLogProvider, memoryPool);
        this.scheduleTransactionTimeout(transactionTimeout);
    }

    public Optional<GraphDatabaseAPI> getGraphDatabaseAPI(String databaseName) {
        Optional<GraphDatabaseAPI> database;
        try {
            database = Optional.of((GraphDatabaseAPI)this.managementService.database(databaseName));
        }
        catch (DatabaseNotFoundException e) {
            database = Optional.empty();
        }
        return database;
    }

    public TransactionRegistry getTransactionRegistry() {
        return this.transactionRegistry;
    }

    public TransactionFacade createTransactionFacade(GraphDatabaseAPI databaseAPI, MemoryTracker memoryTracker) {
        DependencyResolver dependencyResolver = databaseAPI.getDependencyResolver();
        memoryTracker.allocateHeap(TransactionFacade.SHALLOW_SIZE);
        return new TransactionFacade(databaseAPI, (QueryExecutionEngine)dependencyResolver.resolveDependency(QueryExecutionEngine.class), this.transactionRegistry);
    }

    private void scheduleTransactionTimeout(Duration timeout) {
        Clock clock = Clocks.systemClock();
        long timeoutMillis = timeout.toMillis();
        long runEvery = Math.round((double)timeoutMillis / 2.0);
        this.jobScheduler.scheduleRecurring(Group.SERVER_TRANSACTION_TIMEOUT, JobMonitoringParams.systemJob((String)"Timeout of HTTP transactions"), () -> {
            long maxAge = clock.millis() - timeoutMillis;
            this.transactionRegistry.rollbackSuspendedTransactionsIdleSince(maxAge);
        }, runEvery, TimeUnit.MILLISECONDS);
    }
}

