/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.net.URI;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.neo4j.server.rest.repr.BadInputException;
import org.neo4j.server.rest.repr.EntityRepresentation;
import org.neo4j.server.rest.repr.ExceptionRepresentation;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.RepresentationWriteHandler;
import org.neo4j.server.rest.repr.StreamingFormat;
import org.neo4j.server.web.HttpHeaderUtils;
import org.neo4j.string.UTF8;

public class OutputFormat {
    private final RepresentationFormat format;
    private final URI baseUri;
    private RepresentationWriteHandler representationWriteHandler = RepresentationWriteHandler.DO_NOTHING;

    public OutputFormat(RepresentationFormat format, URI baseUri) {
        this.format = format;
        this.baseUri = baseUri;
    }

    public void setRepresentationWriteHandler(RepresentationWriteHandler representationWriteHandler) {
        this.representationWriteHandler = representationWriteHandler;
    }

    public RepresentationWriteHandler getRepresentationWriteHandler() {
        return this.representationWriteHandler;
    }

    public final Response ok(Representation representation) {
        if (representation.isEmpty()) {
            return this.noContent();
        }
        return this.response(Response.ok(), representation);
    }

    public final <REPR extends Representation> Response okIncludeLocation(REPR representation) {
        if (representation.isEmpty()) {
            return this.noContent();
        }
        return this.response(Response.ok().header("Location", (Object)this.uri((EntityRepresentation)representation)), representation);
    }

    public final <REPR extends Representation> Response created(REPR representation) {
        return this.response(Response.created((URI)this.uri((EntityRepresentation)representation)), representation);
    }

    public final Response response(Response.StatusType status, Representation representation) {
        return this.response(Response.status((Response.StatusType)status), representation);
    }

    public Response badRequest(Throwable exception) {
        return this.response(Response.status((Response.Status)Response.Status.BAD_REQUEST), (Representation)new ExceptionRepresentation(exception));
    }

    public Response notFound(Throwable exception) {
        return this.response(Response.status((Response.Status)Response.Status.NOT_FOUND), (Representation)new ExceptionRepresentation(exception));
    }

    public Response notFound() {
        this.representationWriteHandler.onRepresentationFinal();
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    public Response seeOther(URI uri) {
        return Response.seeOther((URI)this.baseUri.resolve(uri)).build();
    }

    public Response conflict(Throwable exception) {
        return this.response(Response.status((Response.Status)Response.Status.CONFLICT), (Representation)new ExceptionRepresentation(exception));
    }

    public final <REPR extends Representation> Response conflict(REPR representation) {
        return this.response(Response.status((Response.Status)Response.Status.CONFLICT), representation);
    }

    public Response serverErrorWithoutLegacyStacktrace(Throwable exception) {
        return this.response(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR), (Representation)new ExceptionRepresentation(exception, false));
    }

    public Response serverError(Throwable exception) {
        return this.response(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR), (Representation)new ExceptionRepresentation(exception));
    }

    private URI uri(EntityRepresentation representation) {
        return URI.create(this.assemble((Representation)representation.selfUri()));
    }

    protected Response response(Response.ResponseBuilder response, Representation representation) {
        return this.formatRepresentation(response, representation).type(HttpHeaderUtils.mediaTypeWithCharsetUtf8(this.getMediaType())).build();
    }

    private Response.ResponseBuilder formatRepresentation(Response.ResponseBuilder response, Representation representation) {
        this.representationWriteHandler.onRepresentationStartWriting();
        boolean mustFail = representation instanceof ExceptionRepresentation;
        if (this.format instanceof StreamingFormat) {
            return response.entity(this.stream(representation, (StreamingFormat)this.format, mustFail));
        }
        return response.entity((Object)this.toBytes(this.assemble(representation), mustFail));
    }

    private Object stream(Representation representation, StreamingFormat streamingFormat, boolean mustFail) {
        return output -> {
            RepresentationFormat outputStreamFormat = streamingFormat.writeTo(output);
            try {
                representation.serialize(outputStreamFormat, this.baseUri);
                if (!mustFail) {
                    this.representationWriteHandler.onRepresentationWritten();
                }
            }
            catch (Exception e) {
                if (e instanceof BadInputException) {
                    throw new WebApplicationException(this.badRequest(e));
                }
                throw new WebApplicationException((Throwable)e, this.serverError(e));
            }
            finally {
                this.representationWriteHandler.onRepresentationFinal();
            }
        };
    }

    public static void write(Representation representation, RepresentationFormat format, URI baseUri) {
        representation.serialize(format, baseUri);
    }

    private byte[] toBytes(String entity, boolean mustFail) {
        byte[] entityAsBytes = UTF8.encode((String)entity);
        if (!mustFail) {
            this.representationWriteHandler.onRepresentationWritten();
        }
        this.representationWriteHandler.onRepresentationFinal();
        return entityAsBytes;
    }

    public MediaType getMediaType() {
        return this.format.mediaType;
    }

    public String assemble(Representation representation) {
        return representation.serialize(this.format, this.baseUri);
    }

    public Response noContent() {
        this.representationWriteHandler.onRepresentationStartWriting();
        this.representationWriteHandler.onRepresentationWritten();
        this.representationWriteHandler.onRepresentationFinal();
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    public Response methodNotAllowed(UnsupportedOperationException e) {
        return this.response(Response.status((int)405), (Representation)new ExceptionRepresentation(e));
    }

    public Response ok() {
        this.representationWriteHandler.onRepresentationStartWriting();
        this.representationWriteHandler.onRepresentationWritten();
        this.representationWriteHandler.onRepresentationFinal();
        return Response.ok().build();
    }

    public Response badRequest(MediaType mediaType, String entity) {
        this.representationWriteHandler.onRepresentationStartWriting();
        this.representationWriteHandler.onRepresentationFinal();
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(mediaType).entity((Object)entity).build();
    }
}

