/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationType;

public abstract class ObjectRepresentation
extends MappingRepresentation {
    private static final ConcurrentHashMap<Class<?>, Map<String, PropertyGetter>> serializations = new ConcurrentHashMap();
    private final Map<String, PropertyGetter> serialization = ObjectRepresentation.serialization(((Object)((Object)this)).getClass());

    public ObjectRepresentation(RepresentationType type) {
        super(type);
    }

    public ObjectRepresentation(String type) {
        super(type);
    }

    private static Map<String, PropertyGetter> serialization(Class<? extends ObjectRepresentation> type) {
        Map serialization = serializations.computeIfAbsent(type, ObjectRepresentation::buildSerialization);
        return serialization;
    }

    private static Map<String, PropertyGetter> buildSerialization(Class<?> type) {
        HashMap<String, PropertyGetter> serialization = new HashMap<String, PropertyGetter>();
        for (Method method : type.getMethods()) {
            Mapping property = method.getAnnotation(Mapping.class);
            if (property == null) continue;
            serialization.put(property.value(), ObjectRepresentation.getter(method));
        }
        return serialization;
    }

    private static PropertyGetter getter(final Method method) {
        return new PropertyGetter(method){

            @Override
            Object get(ObjectRepresentation object) {
                Throwable e;
                try {
                    return method.invoke((Object)object, new Object[0]);
                }
                catch (InvocationTargetException ex) {
                    e = ex.getTargetException();
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    if (e instanceof Error) {
                        throw (Error)e;
                    }
                }
                catch (Exception ex) {
                    e = ex;
                }
                throw new IllegalStateException("Serialization failure", e);
            }
        };
    }

    protected final void serialize(MappingSerializer serializer) {
        for (Map.Entry<String, PropertyGetter> property : this.serialization.entrySet()) {
            property.getValue().putTo(serializer, this, property.getKey());
        }
        this.extraData(serializer);
    }

    protected void extraData(MappingSerializer serializer) {
    }

    private static abstract class PropertyGetter {
        PropertyGetter(Method method) {
            if (method.getParameterTypes().length != 0) {
                throw new IllegalStateException("Property getter method may not have any parameters.");
            }
            if (!Representation.class.isAssignableFrom(method.getReturnType())) {
                throw new IllegalStateException("Property getter must return Representation object.");
            }
        }

        void putTo(MappingSerializer serializer, ObjectRepresentation object, String key) {
            Object value = this.get(object);
            if (value != null) {
                ((Representation)value).putTo(serializer, key);
            }
        }

        abstract Object get(ObjectRepresentation var1);
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    protected static @interface Mapping {
        public String value();
    }
}

