/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.format.output.eventsource;

import com.fasterxml.jackson.core.JsonFactory;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import org.neo4j.server.http.cypher.TransactionHandle;
import org.neo4j.server.http.cypher.format.DefaultJsonFactory;
import org.neo4j.server.http.cypher.format.api.OutputEventSource;
import org.neo4j.server.http.cypher.format.output.eventsource.EventSourceSerializer;

public abstract class AbstractEventSourceJoltMessageBodyWriter
implements MessageBodyWriter<OutputEventSource> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return OutputEventSource.class.isAssignableFrom(type);
    }

    public void writeTo(OutputEventSource outputEventSource, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream output) throws WebApplicationException {
        TransactionHandle transaction = outputEventSource.getTransactionHandle();
        Map<String, Object> parameters = outputEventSource.getParameters();
        boolean joltStrictModeEnabled = this.isJoltStrictModeEnabled(httpHeaders);
        JsonFactory jsonFactory = DefaultJsonFactory.INSTANCE.get();
        EventSourceSerializer serializer = this.createSerializer(output, jsonFactory, transaction, parameters, joltStrictModeEnabled);
        outputEventSource.produceEvents(serializer::handleEvent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isJoltStrictModeEnabled(MultivaluedMap<String, Object> httpHeaders) {
        Predicate<MediaType> isStrictJolt = s -> s.isCompatible(this.getMediaType()) && Boolean.parseBoolean(s.getParameters().getOrDefault("strict", Boolean.FALSE.toString()));
        if (!httpHeaders.containsKey((Object)"Content-Type")) return false;
        if (!((List)httpHeaders.get((Object)"Content-Type")).stream().map(MediaType.class::cast).anyMatch(isStrictJolt)) return false;
        return true;
    }

    protected abstract MediaType getMediaType();

    protected abstract EventSourceSerializer createSerializer(OutputStream var1, JsonFactory var2, TransactionHandle var3, Map<String, Object> var4, boolean var5);
}

