/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.format.jolt;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.neo4j.server.http.cypher.format.jolt.Sigil;

final class JoltLongSerializer<T>
extends StdSerializer<T> {
    JoltLongSerializer(Class<T> t) {
        super(t);
    }

    public void serialize(T value, JsonGenerator generator, SerializerProvider provider) throws IOException {
        generator.writeStartObject(value);
        long longValue = (Long)value;
        if (longValue >= Integer.MIN_VALUE && longValue < Integer.MAX_VALUE) {
            generator.writeFieldName(Sigil.INTEGER.getValue());
        } else {
            generator.writeFieldName(Sigil.REAL.getValue());
        }
        generator.writeString(String.valueOf(longValue));
        generator.writeEndObject();
    }
}

