/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher;

import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.server.http.cypher.ErrorInvocation;
import org.neo4j.server.http.cypher.HttpTransactionManager;
import org.neo4j.server.http.cypher.Invocation;
import org.neo4j.server.http.cypher.OutputEventStreamImpl;
import org.neo4j.server.http.cypher.RollbackInvocation;
import org.neo4j.server.http.cypher.TransactionFacade;
import org.neo4j.server.http.cypher.TransactionHandle;
import org.neo4j.server.http.cypher.TransactionLifecycleException;
import org.neo4j.server.http.cypher.format.api.InputEventStream;
import org.neo4j.server.http.cypher.format.api.TransactionUriScheme;
import org.neo4j.server.rest.Neo4jError;
import org.neo4j.server.rest.dbms.AuthorizedRequestWrapper;
import org.neo4j.server.rest.web.HttpConnectionInfoFactory;
import org.neo4j.server.web.HttpHeaderUtils;

public abstract class AbstractCypherResource {
    private final HttpTransactionManager httpTransactionManager;
    private final TransactionUriScheme uriScheme;
    private final Log log;
    private final HttpHeaders headers;
    private final HttpServletRequest request;
    private final String databaseName;

    AbstractCypherResource(HttpTransactionManager httpTransactionManager, UriInfo uriInfo, Log log, HttpHeaders headers, HttpServletRequest request, String databaseName) {
        this.httpTransactionManager = httpTransactionManager;
        this.databaseName = databaseName;
        this.uriScheme = new TransactionUriBuilder(this.dbUri(uriInfo, databaseName), this.cypherUri(uriInfo, databaseName));
        this.log = log;
        this.headers = headers;
        this.request = request;
    }

    protected abstract URI dbUri(UriInfo var1, String var2);

    protected abstract URI cypherUri(UriInfo var1, String var2);

    @POST
    public Response executeStatementsInNewTransaction(InputEventStream inputEventStream) {
        InputEventStream inputStream = this.ensureNotNull(inputEventStream);
        Optional<GraphDatabaseAPI> graphDatabaseAPI = this.httpTransactionManager.getGraphDatabaseAPI(this.databaseName);
        return graphDatabaseAPI.map(databaseAPI -> {
            if (this.isDatabaseNotAvailable((GraphDatabaseAPI)databaseAPI)) {
                return this.createNonAvailableDatabaseResponse(inputStream.getParameters());
            }
            TransactionFacade transactionFacade = this.httpTransactionManager.createTransactionFacade((GraphDatabaseAPI)databaseAPI);
            TransactionHandle transactionHandle = this.createNewTransactionHandle(transactionFacade, this.headers, this.request, false);
            Invocation invocation = new Invocation(this.log, transactionHandle, this.uriScheme.txCommitUri(transactionHandle.getId()), inputStream, false);
            OutputEventStreamImpl outputStream = new OutputEventStreamImpl(inputStream.getParameters(), transactionHandle, this.uriScheme, invocation::execute);
            return Response.created((URI)transactionHandle.uri()).entity((Object)outputStream).build();
        }).orElse(this.createNonExistentDatabaseResponse(inputStream.getParameters()));
    }

    @POST
    @Path(value="/{id}")
    public Response executeStatements(@PathParam(value="id") long id, InputEventStream inputEventStream, @Context UriInfo uriInfo, @Context HttpServletRequest request) {
        return this.executeInExistingTransaction(id, inputEventStream, false);
    }

    @POST
    @Path(value="/{id}/commit")
    public Response commitTransaction(@PathParam(value="id") long id, InputEventStream inputEventStream) {
        return this.executeInExistingTransaction(id, inputEventStream, true);
    }

    @POST
    @Path(value="/commit")
    public Response commitNewTransaction(@Context HttpHeaders headers, InputEventStream inputEventStream, @Context HttpServletRequest request) {
        InputEventStream inputStream = this.ensureNotNull(inputEventStream);
        Optional<GraphDatabaseAPI> graphDatabaseAPI = this.httpTransactionManager.getGraphDatabaseAPI(this.databaseName);
        return graphDatabaseAPI.map(databaseAPI -> {
            if (this.isDatabaseNotAvailable((GraphDatabaseAPI)databaseAPI)) {
                return this.createNonAvailableDatabaseResponse(inputStream.getParameters());
            }
            TransactionFacade transactionFacade = this.httpTransactionManager.createTransactionFacade((GraphDatabaseAPI)databaseAPI);
            TransactionHandle transactionHandle = this.createNewTransactionHandle(transactionFacade, headers, request, true);
            Invocation invocation = new Invocation(this.log, transactionHandle, null, inputStream, true);
            OutputEventStreamImpl outputStream = new OutputEventStreamImpl(inputStream.getParameters(), transactionHandle, this.uriScheme, invocation::execute);
            return Response.ok((Object)outputStream).build();
        }).orElse(this.createNonExistentDatabaseResponse(inputStream.getParameters()));
    }

    @DELETE
    @Path(value="/{id}")
    public Response rollbackTransaction(@PathParam(value="id") long id) {
        Optional<GraphDatabaseAPI> graphDatabaseAPI = this.httpTransactionManager.getGraphDatabaseAPI(this.databaseName);
        return graphDatabaseAPI.map(databaseAPI -> {
            TransactionHandle transactionHandle;
            if (this.isDatabaseNotAvailable((GraphDatabaseAPI)databaseAPI)) {
                return this.createNonAvailableDatabaseResponse(Collections.emptyMap());
            }
            TransactionFacade transactionFacade = this.httpTransactionManager.createTransactionFacade((GraphDatabaseAPI)databaseAPI);
            try {
                transactionHandle = transactionFacade.terminate(id);
            }
            catch (TransactionLifecycleException e) {
                return this.invalidTransaction(transactionFacade, e, Collections.emptyMap());
            }
            RollbackInvocation invocation = new RollbackInvocation(this.log, transactionHandle);
            OutputEventStreamImpl outputEventStream = new OutputEventStreamImpl(Collections.emptyMap(), null, this.uriScheme, invocation::execute);
            return Response.ok().entity((Object)outputEventStream).build();
        }).orElse(this.createNonExistentDatabaseResponse(Collections.emptyMap()));
    }

    private boolean isDatabaseNotAvailable(GraphDatabaseAPI databaseAPI) {
        return !databaseAPI.isAvailable(0L);
    }

    private TransactionHandle createNewTransactionHandle(TransactionFacade transactionFacade, HttpHeaders headers, HttpServletRequest request, boolean implicitTransaction) {
        LoginContext loginContext = AuthorizedRequestWrapper.getLoginContextFromHttpServletRequest(request);
        long customTransactionTimeout = HttpHeaderUtils.getTransactionTimeout(headers, this.log);
        ClientConnectionInfo connectionInfo = HttpConnectionInfoFactory.create(request);
        return transactionFacade.newTransactionHandle(this.uriScheme, implicitTransaction, loginContext, connectionInfo, customTransactionTimeout);
    }

    private Response executeInExistingTransaction(long transactionId, InputEventStream inputEventStream, boolean finishWithCommit) {
        InputEventStream inputStream = this.ensureNotNull(inputEventStream);
        Optional<GraphDatabaseAPI> graphDatabaseAPI = this.httpTransactionManager.getGraphDatabaseAPI(this.databaseName);
        return graphDatabaseAPI.map(databaseAPI -> {
            TransactionHandle transactionHandle;
            if (this.isDatabaseNotAvailable((GraphDatabaseAPI)databaseAPI)) {
                return this.createNonAvailableDatabaseResponse(inputStream.getParameters());
            }
            TransactionFacade transactionFacade = this.httpTransactionManager.createTransactionFacade((GraphDatabaseAPI)databaseAPI);
            try {
                transactionHandle = transactionFacade.findTransactionHandle(transactionId);
            }
            catch (TransactionLifecycleException e) {
                return this.invalidTransaction(transactionFacade, e, inputStream.getParameters());
            }
            Invocation invocation = new Invocation(this.log, transactionHandle, this.uriScheme.txCommitUri(transactionHandle.getId()), inputStream, finishWithCommit);
            OutputEventStreamImpl outputEventStream = new OutputEventStreamImpl(inputStream.getParameters(), transactionHandle, this.uriScheme, invocation::execute);
            return Response.ok((Object)outputEventStream).build();
        }).orElse(this.createNonExistentDatabaseResponse(inputStream.getParameters()));
    }

    private Response invalidTransaction(TransactionFacade transactionFacade, TransactionLifecycleException e, Map<String, Object> parameters) {
        ErrorInvocation errorInvocation = new ErrorInvocation(e.toNeo4jError());
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new OutputEventStreamImpl(parameters, null, this.uriScheme, errorInvocation::execute)).build();
    }

    private InputEventStream ensureNotNull(InputEventStream inputEventStream) {
        return Objects.requireNonNullElse(inputEventStream, InputEventStream.EMPTY);
    }

    private Response createNonExistentDatabaseResponse(Map<String, Object> parameters) {
        ErrorInvocation errorInvocation = new ErrorInvocation(new Neo4jError((Status)Status.Database.DatabaseNotFound, String.format("The database requested does not exists. Requested database name: '%s'.", this.databaseName)));
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new OutputEventStreamImpl(parameters, null, this.uriScheme, errorInvocation::execute)).build();
    }

    private Response createNonAvailableDatabaseResponse(Map<String, Object> parameters) {
        ErrorInvocation errorInvocation = new ErrorInvocation(new Neo4jError((Status)Status.Database.DatabaseUnavailable, String.format("Requested database is not available. Requested database name: '%s'.", this.databaseName)));
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new OutputEventStreamImpl(parameters, null, this.uriScheme, errorInvocation::execute)).build();
    }

    private static class TransactionUriBuilder
    implements TransactionUriScheme {
        private final URI dbUri;
        private final URI cypherUri;

        TransactionUriBuilder(URI dbUri, URI cypherUri) {
            this.dbUri = dbUri;
            this.cypherUri = cypherUri;
        }

        @Override
        public URI txUri(long id) {
            return this.transactionBuilder(id).build(new Object[0]);
        }

        @Override
        public URI txCommitUri(long id) {
            return this.transactionBuilder(id).path("/commit").build(new Object[0]);
        }

        @Override
        public URI dbUri() {
            return this.dbUri;
        }

        private UriBuilder transactionBuilder(long id) {
            return UriBuilder.fromUri((URI)this.cypherUri).path("/" + id);
        }
    }
}

