/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.util.Arrays;
import java.util.function.Supplier;
import org.neo4j.collection.Dependencies;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.AbstractNeoWebServer;
import org.neo4j.server.modules.AuthorizationModule;
import org.neo4j.server.modules.DBMSModule;
import org.neo4j.server.modules.LegacyTransactionModule;
import org.neo4j.server.modules.Neo4jBrowserModule;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.modules.ThirdPartyJAXRSModule;
import org.neo4j.server.modules.TransactionModule;
import org.neo4j.server.rest.discovery.CommunityDiscoverableURIs;
import org.neo4j.server.rest.discovery.DiscoverableURIs;
import org.neo4j.server.web.Jetty9WebServer;
import org.neo4j.server.web.WebServer;

public class CommunityNeoWebServer
extends AbstractNeoWebServer {
    public CommunityNeoWebServer(DatabaseManagementService managementService, Dependencies globalDependencies, Config config, LogProvider userLogProvider, DbmsInfo dbmsInfo) {
        super(managementService, globalDependencies, config, userLogProvider, dbmsInfo);
    }

    @Override
    protected Iterable<ServerModule> createServerModules() {
        return Arrays.asList(this.createDBMSModule(), new TransactionModule(this.webServer, this.getConfig()), new LegacyTransactionModule(this.webServer, this.getConfig()), new ThirdPartyJAXRSModule(this.webServer, this.getConfig(), this.userLogProvider), new Neo4jBrowserModule(this.webServer), this.createAuthorizationModule());
    }

    @Override
    protected WebServer createWebServer() {
        Dependencies globalDependencies = this.getGlobalDependencies();
        NetworkConnectionTracker connectionTracker = (NetworkConnectionTracker)globalDependencies.resolveDependency(NetworkConnectionTracker.class);
        Jetty9WebServer webServer = new Jetty9WebServer(this.userLogProvider, this.getConfig(), connectionTracker);
        globalDependencies.satisfyDependency((Object)webServer);
        return webServer;
    }

    protected DBMSModule createDBMSModule() {
        Supplier<DiscoverableURIs> discoverableURIs = () -> CommunityDiscoverableURIs.communityDiscoverableURIs(this.getConfig(), this.connectorPortRegister);
        return new DBMSModule(this.webServer, this.getConfig(), discoverableURIs, this.userLogProvider);
    }

    protected AuthorizationModule createAuthorizationModule() {
        return new AuthorizationModule(this.webServer, this.authManagerSupplier, this.userLogProvider, this.getConfig(), this.getUriWhitelist());
    }
}

