/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.format.output.json;

import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.neo4j.server.http.cypher.TransactionHandle;
import org.neo4j.server.http.cypher.format.api.FailureEvent;
import org.neo4j.server.http.cypher.format.api.OutputEvent;
import org.neo4j.server.http.cypher.format.api.OutputEventSource;
import org.neo4j.server.http.cypher.format.api.RecordEvent;
import org.neo4j.server.http.cypher.format.api.StatementEndEvent;
import org.neo4j.server.http.cypher.format.api.StatementStartEvent;
import org.neo4j.server.http.cypher.format.api.TransactionInfoEvent;
import org.neo4j.server.http.cypher.format.api.TransactionUriScheme;
import org.neo4j.server.http.cypher.format.input.json.InputStatement;
import org.neo4j.server.http.cypher.format.input.json.JsonMessageBodyReader;
import org.neo4j.server.http.cypher.format.output.json.ExecutionResultSerializer;

@Provider
@Produces(value={"application/json"})
public class JsonMessageBodyWriter
implements MessageBodyWriter<OutputEventSource> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return OutputEventSource.class.isAssignableFrom(type);
    }

    public void writeTo(OutputEventSource outputEventSource, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws WebApplicationException {
        TransactionHandle transaction = outputEventSource.getTransactionHandle();
        TransactionUriScheme uriInfo = outputEventSource.getUriInfo();
        ExecutionResultSerializer serializer = new ExecutionResultSerializer(entityStream, uriInfo.dbUri(), transaction);
        outputEventSource.produceEvents(outputEvent -> this.handleEvent((OutputEvent)outputEvent, serializer, outputEventSource.getParameters()));
    }

    private void handleEvent(OutputEvent event, ExecutionResultSerializer serializer, Map<String, Object> parameters) {
        switch (event.getType()) {
            case STATEMENT_START: {
                StatementStartEvent statementStartEvent = (StatementStartEvent)event;
                InputStatement inputStatement = JsonMessageBodyReader.getInputStatement(parameters, statementStartEvent.getStatement());
                serializer.writeStatementStart(statementStartEvent, inputStatement);
                break;
            }
            case RECORD: {
                serializer.writeRecord((RecordEvent)event);
                break;
            }
            case STATEMENT_END: {
                StatementEndEvent statementEndEvent = (StatementEndEvent)event;
                serializer.writeStatementEnd(statementEndEvent);
                break;
            }
            case FAILURE: {
                FailureEvent failureEvent = (FailureEvent)event;
                serializer.writeFailure(failureEvent);
                break;
            }
            case TRANSACTION_INFO: {
                TransactionInfoEvent transactionInfoEvent = (TransactionInfoEvent)event;
                serializer.writeTransactionInfo(transactionInfoEvent);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported event encountered:" + event.getType());
            }
        }
    }
}

