/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.format.output.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.InputPosition;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.server.http.cypher.TransactionHandle;
import org.neo4j.server.http.cypher.TransactionStateChecker;
import org.neo4j.server.http.cypher.format.api.ConnectionException;
import org.neo4j.server.http.cypher.format.api.FailureEvent;
import org.neo4j.server.http.cypher.format.api.RecordEvent;
import org.neo4j.server.http.cypher.format.api.StatementEndEvent;
import org.neo4j.server.http.cypher.format.api.StatementStartEvent;
import org.neo4j.server.http.cypher.format.api.TransactionInfoEvent;
import org.neo4j.server.http.cypher.format.api.TransactionNotificationState;
import org.neo4j.server.http.cypher.format.common.Neo4jJsonCodec;
import org.neo4j.server.http.cypher.format.input.json.InputStatement;
import org.neo4j.server.http.cypher.format.output.json.AggregatingWriter;
import org.neo4j.server.http.cypher.format.output.json.ResultDataContent;
import org.neo4j.server.http.cypher.format.output.json.ResultDataContentWriter;
import org.neo4j.server.rest.domain.JsonHelper;

class ExecutionResultSerializer {
    private State currentState = State.EMPTY;
    private static final JsonFactory JSON_FACTORY = new JsonFactory().disable(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM);
    private final JsonGenerator out;
    private final URI baseUri;
    private final TransactionHandle transactionHandle;
    private final List<Notification> notifications = new ArrayList<Notification>();
    private final List<FailureEvent> errors = new ArrayList<FailureEvent>();
    private final OutputStream output;
    private ResultDataContentWriter writer;
    private InputStatement inputStatement;

    ExecutionResultSerializer(OutputStream output, URI baseUri, TransactionHandle transactionHandle) {
        JsonGenerator generator;
        this.baseUri = baseUri;
        this.transactionHandle = transactionHandle;
        this.output = output;
        JSON_FACTORY.setCodec((ObjectCodec)new Neo4jJsonCodec(transactionHandle));
        try {
            generator = JSON_FACTORY.createJsonGenerator(output);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create JSON generator", e);
        }
        this.out = generator;
    }

    void writeStatementStart(StatementStartEvent statementStartEvent, InputStatement inputStatement) {
        this.inputStatement = inputStatement;
        this.writer = this.configureWriters(inputStatement.resultDataContents());
        try {
            this.ensureResultsFieldOpen();
            this.out.writeStartObject();
            List<String> columns = statementStartEvent.getColumns();
            this.writeColumns(columns);
            this.out.writeArrayFieldStart("data");
            this.currentState = State.STATEMENT_OPEN;
        }
        catch (JsonGenerationException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new ConnectionException("Failed to write to the connection", e);
        }
    }

    void writeRecord(RecordEvent recordEvent) {
        try {
            TransactionStateChecker txStateChecker = TransactionStateChecker.create(this.transactionHandle.getContext());
            this.out.writeStartObject();
            try {
                this.writer.write(this.out, recordEvent, txStateChecker);
            }
            finally {
                this.out.writeEndObject();
            }
            this.flush();
        }
        catch (JsonGenerationException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new ConnectionException("Failed to write to the connection", e);
        }
    }

    private ResultDataContentWriter configureWriters(List<ResultDataContent> specifiers) {
        if (specifiers == null || specifiers.size() == 0) {
            return ResultDataContent.row.writer(this.baseUri);
        }
        if (specifiers.size() == 1) {
            return specifiers.get(0).writer(this.baseUri);
        }
        ResultDataContentWriter[] writers = new ResultDataContentWriter[specifiers.size()];
        for (int i = 0; i < specifiers.size(); ++i) {
            writers[i] = specifiers.get(i).writer(this.baseUri);
        }
        return new AggregatingWriter(writers);
    }

    void writeStatementEnd(StatementEndEvent statementEndEvent) {
        try {
            this.out.writeEndArray();
            if (this.inputStatement.includeStats()) {
                this.writeStats(statementEndEvent.getQueryStatistics());
            }
            if (statementEndEvent.getQueryExecutionType().requestedExecutionPlanDescription()) {
                this.writeRootPlanDescription(statementEndEvent.getExecutionPlanDescription());
            }
            this.out.writeEndObject();
            this.currentState = State.RESULTS_OPEN;
            statementEndEvent.getNotifications().forEach(this.notifications::add);
        }
        catch (JsonGenerationException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new ConnectionException("Failed to write to the connection", e);
        }
    }

    void writeTransactionInfo(TransactionInfoEvent transactionInfoEvent) {
        try {
            this.ensureDocumentOpen();
            this.ensureResultsFieldClosed();
            this.writeNotifications(this.notifications);
            this.writeErrors();
            if (transactionInfoEvent.getCommitUri() != null) {
                this.out.writeStringField("commit", transactionInfoEvent.getCommitUri().toString());
            }
            if (transactionInfoEvent.getNotification() == TransactionNotificationState.OPEN) {
                this.out.writeObjectFieldStart("transaction");
                if (transactionInfoEvent.getExpirationTimestamp() >= 0L) {
                    String expires = Instant.ofEpochMilli(transactionInfoEvent.getExpirationTimestamp()).atZone(ZoneId.of("GMT")).format(DateTimeFormatter.RFC_1123_DATE_TIME);
                    this.out.writeStringField("expires", expires);
                }
                this.out.writeEndObject();
            }
            this.out.writeEndObject();
            this.flush();
        }
        catch (JsonGenerationException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new ConnectionException("Failed to write to the connection", e);
        }
    }

    void writeFailure(FailureEvent failureEvent) {
        try {
            this.errors.add(failureEvent);
            this.ensureStatementFieldClosed();
        }
        catch (JsonGenerationException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new ConnectionException("Failed to write to the connection", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNotifications(Iterable<Notification> notifications) throws IOException {
        if (!notifications.iterator().hasNext()) {
            return;
        }
        try {
            this.ensureResultsFieldClosed();
            this.out.writeArrayFieldStart("notifications");
            try {
                for (Notification notification : notifications) {
                    this.out.writeStartObject();
                    try {
                        this.out.writeStringField("code", notification.getCode());
                        this.out.writeStringField("severity", notification.getSeverity().toString());
                        this.out.writeStringField("title", notification.getTitle());
                        this.out.writeStringField("description", notification.getDescription());
                        this.writePosition(notification.getPosition());
                    }
                    finally {
                        this.out.writeEndObject();
                    }
                }
            }
            finally {
                this.out.writeEndArray();
            }
        }
        catch (IOException e) {
            throw new ConnectionException("Failed to write to the response stream", e);
        }
    }

    private void writePosition(InputPosition position) throws IOException {
        if (position == InputPosition.empty) {
            return;
        }
        this.out.writeObjectFieldStart("position");
        try {
            this.out.writeNumberField("offset", position.getOffset());
            this.out.writeNumberField("line", position.getLine());
            this.out.writeNumberField("column", position.getColumn());
        }
        finally {
            this.out.writeEndObject();
        }
    }

    private void writeStats(QueryStatistics stats) throws IOException {
        this.out.writeObjectFieldStart("stats");
        try {
            this.out.writeBooleanField("contains_updates", stats.containsUpdates());
            this.out.writeNumberField("nodes_created", stats.getNodesCreated());
            this.out.writeNumberField("nodes_deleted", stats.getNodesDeleted());
            this.out.writeNumberField("properties_set", stats.getPropertiesSet());
            this.out.writeNumberField("relationships_created", stats.getRelationshipsCreated());
            this.out.writeNumberField("relationship_deleted", stats.getRelationshipsDeleted());
            this.out.writeNumberField("labels_added", stats.getLabelsAdded());
            this.out.writeNumberField("labels_removed", stats.getLabelsRemoved());
            this.out.writeNumberField("indexes_added", stats.getIndexesAdded());
            this.out.writeNumberField("indexes_removed", stats.getIndexesRemoved());
            this.out.writeNumberField("constraints_added", stats.getConstraintsAdded());
            this.out.writeNumberField("constraints_removed", stats.getConstraintsRemoved());
            this.out.writeBooleanField("contains_system_updates", stats.containsSystemUpdates());
            this.out.writeNumberField("system_updates", stats.getSystemUpdates());
        }
        finally {
            this.out.writeEndObject();
        }
    }

    private void writeRootPlanDescription(ExecutionPlanDescription planDescription) throws IOException {
        this.out.writeObjectFieldStart("plan");
        try {
            this.out.writeObjectFieldStart("root");
            try {
                this.writePlanDescriptionObjectBody(planDescription);
            }
            finally {
                this.out.writeEndObject();
            }
        }
        finally {
            this.out.writeEndObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePlanDescriptionObjectBody(ExecutionPlanDescription planDescription) throws IOException {
        this.out.writeStringField("operatorType", planDescription.getName());
        this.writePlanArgs(planDescription);
        this.writePlanIdentifiers(planDescription);
        List children = planDescription.getChildren();
        this.out.writeArrayFieldStart("children");
        try {
            for (ExecutionPlanDescription child : children) {
                this.out.writeStartObject();
                try {
                    this.writePlanDescriptionObjectBody(child);
                }
                finally {
                    this.out.writeEndObject();
                }
            }
        }
        finally {
            this.out.writeEndArray();
        }
    }

    private void writePlanArgs(ExecutionPlanDescription planDescription) throws IOException {
        for (Map.Entry entry : planDescription.getArguments().entrySet()) {
            String fieldName = (String)entry.getKey();
            Object fieldValue = entry.getValue();
            this.out.writeFieldName(fieldName);
            JsonHelper.writeValue(this.out, fieldValue);
        }
    }

    private void writePlanIdentifiers(ExecutionPlanDescription planDescription) throws IOException {
        this.out.writeArrayFieldStart("identifiers");
        for (String id : planDescription.getIdentifiers()) {
            this.out.writeString(id);
        }
        this.out.writeEndArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeErrors() {
        try {
            this.ensureDocumentOpen();
            this.out.writeArrayFieldStart("errors");
            try {
                for (FailureEvent error : this.errors) {
                    try {
                        this.out.writeStartObject();
                        this.out.writeObjectField("code", (Object)error.getStatus().code().serialize());
                        this.out.writeObjectField("message", (Object)error.getMessage());
                    }
                    finally {
                        this.out.writeEndObject();
                    }
                }
            }
            finally {
                this.out.writeEndArray();
                this.currentState = State.ERRORS_WRITTEN;
            }
        }
        catch (IOException e) {
            throw new ConnectionException("Failed to write to the response stream", e);
        }
    }

    private void ensureDocumentOpen() throws IOException {
        if (this.currentState == State.EMPTY) {
            this.out.writeStartObject();
            this.currentState = State.DOCUMENT_OPEN;
        }
    }

    private void ensureResultsFieldOpen() throws IOException {
        this.ensureDocumentOpen();
        if (this.currentState == State.DOCUMENT_OPEN) {
            this.out.writeArrayFieldStart("results");
            this.currentState = State.RESULTS_OPEN;
        }
    }

    private void ensureResultsFieldClosed() throws IOException {
        this.ensureResultsFieldOpen();
        if (this.currentState == State.RESULTS_OPEN) {
            this.out.writeEndArray();
            this.currentState = State.RESULTS_CLOSED;
        }
    }

    private void ensureStatementFieldClosed() throws IOException {
        if (this.currentState == State.STATEMENT_OPEN) {
            this.out.writeEndArray();
            this.out.writeEndObject();
            this.currentState = State.RESULTS_OPEN;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeColumns(Iterable<String> columns) throws IOException {
        try {
            this.out.writeArrayFieldStart("columns");
            for (String key : columns) {
                this.out.writeString(key);
            }
        }
        finally {
            this.out.writeEndArray();
        }
    }

    private void flush() throws IOException {
        this.out.flush();
        this.output.flush();
    }

    private static enum State {
        EMPTY,
        DOCUMENT_OPEN,
        RESULTS_OPEN,
        STATEMENT_OPEN,
        RESULTS_CLOSED,
        ERRORS_WRITTEN;

    }
}

