/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher;

import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.neo4j.graphdb.Result;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.server.http.cypher.TransactionRegistry;
import org.neo4j.server.http.cypher.TransactionTerminationHandle;
import org.neo4j.server.http.cypher.TransitionalPeriodTransactionMessContainer;
import org.neo4j.server.http.cypher.TransitionalTxManagementKernelTransaction;
import org.neo4j.server.http.cypher.format.api.Statement;
import org.neo4j.server.http.cypher.format.api.TransactionUriScheme;

public class TransactionHandle
implements TransactionTerminationHandle {
    private final TransitionalPeriodTransactionMessContainer txManagerFacade;
    private final QueryExecutionEngine engine;
    private final TransactionRegistry registry;
    private final TransactionUriScheme uriScheme;
    private final KernelTransaction.Type type;
    private final LoginContext loginContext;
    private final ClientConnectionInfo connectionInfo;
    private final long customTransactionTimeoutMillis;
    private final long id;
    private TransitionalTxManagementKernelTransaction context;
    private final GraphDatabaseQueryService queryService;
    private long expirationTimestamp = -1L;

    TransactionHandle(TransitionalPeriodTransactionMessContainer txManagerFacade, QueryExecutionEngine engine, GraphDatabaseQueryService queryService, TransactionRegistry registry, TransactionUriScheme uriScheme, boolean implicitTransaction, LoginContext loginContext, ClientConnectionInfo connectionInfo, long customTransactionTimeoutMillis) {
        this.txManagerFacade = txManagerFacade;
        this.engine = engine;
        this.queryService = queryService;
        this.registry = registry;
        this.uriScheme = uriScheme;
        this.type = implicitTransaction ? KernelTransaction.Type.implicit : KernelTransaction.Type.explicit;
        this.loginContext = loginContext;
        this.connectionInfo = connectionInfo;
        this.customTransactionTimeoutMillis = customTransactionTimeoutMillis;
        this.id = registry.begin(this);
    }

    URI uri() {
        return this.uriScheme.txUri(this.id);
    }

    boolean isImplicit() {
        return this.type == KernelTransaction.Type.implicit;
    }

    long getExpirationTimestamp() {
        return this.expirationTimestamp;
    }

    long getId() {
        return this.id;
    }

    @Override
    public boolean terminate() {
        if (this.context != null) {
            this.context.terminate();
        }
        return true;
    }

    boolean isPeriodicCommit(String statement) {
        return this.engine.isPeriodicCommit(statement);
    }

    void closeTransactionForPeriodicCommit() {
        this.context.closeTransactionForPeriodicCommit();
    }

    void reopenAfterPeriodicCommit() {
        this.context.reopenAfterPeriodicCommit();
    }

    void ensureActiveTransaction() {
        if (this.context == null) {
            this.context = this.txManagerFacade.newTransaction(this.type, this.loginContext, this.connectionInfo, this.customTransactionTimeoutMillis);
        }
    }

    Result executeStatement(Statement statement, boolean periodicCommit) throws QueryExecutionKernelException {
        if (periodicCommit) {
            Result result;
            GraphDatabaseFacade db = this.txManagerFacade.getDb();
            try (InternalTransaction transaction = db.beginTransaction(KernelTransaction.Type.implicit, this.loginContext, this.connectionInfo, this.customTransactionTimeoutMillis, TimeUnit.MILLISECONDS);){
                result = transaction.execute(statement.getStatement(), statement.getParameters());
                transaction.commit();
            }
            return result;
        }
        TransactionalContext tc = this.txManagerFacade.create(this.queryService, this.context.getInternalTransaction(), statement.getStatement(), statement.getParameters());
        return this.engine.executeQuery(statement.getStatement(), ValueUtils.asMapValue(statement.getParameters()), tc, false);
    }

    void forceRollback() {
        this.context.rollback();
    }

    void suspendTransaction() {
        this.expirationTimestamp = this.registry.release(this.id, this);
    }

    void commit() {
        try {
            this.context.commit();
        }
        finally {
            this.registry.forget(this.id);
        }
    }

    void rollback() {
        try {
            this.context.rollback();
        }
        finally {
            this.registry.forget(this.id);
        }
    }

    boolean hasTransactionContext() {
        return this.context != null;
    }

    public TransitionalTxManagementKernelTransaction getContext() {
        return this.context;
    }
}

