/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.server.web.JettyHttpConnection;
import org.neo4j.server.web.JettyHttpConnectionListener;

public class JettyHttpConnectionFactory
extends HttpConnectionFactory {
    private final NetworkConnectionTracker connectionTracker;
    private final JettyHttpConnectionListener connectionListener;

    public JettyHttpConnectionFactory(NetworkConnectionTracker connectionTracker, HttpConfiguration configuration) {
        super(configuration);
        this.connectionTracker = connectionTracker;
        this.connectionListener = new JettyHttpConnectionListener(connectionTracker);
    }

    public Connection newConnection(Connector connector, EndPoint endPoint) {
        JettyHttpConnection connection = this.createConnection(connector, endPoint);
        connection.addListener(this.connectionListener);
        return this.configure((AbstractConnection)connection, connector, endPoint);
    }

    private JettyHttpConnection createConnection(Connector connector, EndPoint endPoint) {
        String connectionId = this.connectionTracker.newConnectionId(connector.getName());
        return new JettyHttpConnection(connectionId, this.getHttpConfiguration(), connector, endPoint, this.getHttpCompliance(), this.isRecordHttpComplianceViolations());
    }
}

