/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.server.rest.transactional.DeserializationException;
import org.neo4j.server.rest.transactional.Neo4jJsonCodec;
import org.neo4j.server.rest.transactional.ResultDataContent;
import org.neo4j.server.rest.transactional.Statement;
import org.neo4j.server.rest.transactional.error.Neo4jError;

public class StatementDeserializer
extends PrefetchingIterator<Statement> {
    private static final JsonFactory JSON_FACTORY = new JsonFactory().setCodec((ObjectCodec)new Neo4jJsonCodec()).disable(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM);
    private static final Map<String, Object> NO_PARAMETERS = Collections.unmodifiableMap(MapUtil.map((Object[])new Object[0]));
    private final JsonParser input;
    private State state;
    private List<Neo4jError> errors;

    public StatementDeserializer(InputStream input) {
        try {
            this.input = JSON_FACTORY.createJsonParser(input);
            this.state = State.BEFORE_OUTER_ARRAY;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Iterator<Neo4jError> errors() {
        return this.errors == null ? Collections.emptyIterator() : this.errors.iterator();
    }

    protected Statement fetchNextOrNull() {
        try {
            if (this.errors != null) {
                return null;
            }
            switch (this.state) {
                case BEFORE_OUTER_ARRAY: {
                    if (!this.beginsWithCorrectTokens()) {
                        return null;
                    }
                    this.state = State.IN_BODY;
                }
                case IN_BODY: {
                    JsonToken tok;
                    String statement = null;
                    Map<String, Object> parameters = null;
                    List<Object> resultsDataContents = null;
                    boolean includeStats = false;
                    block21: while ((tok = this.input.nextToken()) != null && tok != JsonToken.END_OBJECT) {
                        String currentName;
                        if (tok == JsonToken.END_ARRAY) {
                            this.state = State.FINISHED;
                            return null;
                        }
                        this.input.nextValue();
                        switch (currentName = this.input.getCurrentName()) {
                            case "statement": {
                                statement = (String)this.input.readValueAs(String.class);
                                continue block21;
                            }
                            case "parameters": {
                                parameters = StatementDeserializer.readMap(this.input);
                                continue block21;
                            }
                            case "resultDataContents": {
                                resultsDataContents = StatementDeserializer.readArray(this.input);
                                continue block21;
                            }
                            case "includeStats": {
                                includeStats = this.input.getBooleanValue();
                                continue block21;
                            }
                        }
                        this.discardValue(this.input);
                    }
                    if (statement == null) {
                        this.addError(new Neo4jError((Status)Status.Request.InvalidFormat, new DeserializationException("No statement provided.")));
                        return null;
                    }
                    return new Statement(statement, parameters == null ? NO_PARAMETERS : parameters, includeStats, ResultDataContent.fromNames(resultsDataContents));
                }
                case FINISHED: {
                    return null;
                }
            }
            return null;
        }
        catch (JsonParseException | JsonMappingException e) {
            this.addError(new Neo4jError((Status)Status.Request.InvalidFormat, new DeserializationException("Unable to deserialize request", e)));
            return null;
        }
        catch (IOException e) {
            this.addError(new Neo4jError((Status)Status.Network.CommunicationError, e));
            return null;
        }
        catch (Exception e) {
            this.addError(new Neo4jError((Status)Status.General.UnknownError, e));
            return null;
        }
    }

    private void discardValue(JsonParser input) throws IOException {
        input.readValueAs(Object.class);
    }

    private static Map<String, Object> readMap(JsonParser input) throws IOException {
        return (Map)input.readValueAs(Map.class);
    }

    private static List<Object> readArray(JsonParser input) throws IOException {
        return (List)input.readValueAs(List.class);
    }

    private void addError(Neo4jError error) {
        if (this.errors == null) {
            this.errors = new LinkedList<Neo4jError>();
        }
        this.errors.add(error);
    }

    private boolean beginsWithCorrectTokens() throws IOException {
        List<JsonToken> expectedTokens = Arrays.asList(JsonToken.START_OBJECT, JsonToken.FIELD_NAME, JsonToken.START_ARRAY);
        String expectedField = "statements";
        ArrayList<JsonToken> foundTokens = new ArrayList<JsonToken>();
        for (int i = 0; i < expectedTokens.size(); ++i) {
            JsonToken token = this.input.nextToken();
            if (i == 0 && token == null) {
                return false;
            }
            if (token == JsonToken.FIELD_NAME && !expectedField.equals(this.input.getText())) {
                this.addError(new Neo4jError((Status)Status.Request.InvalidFormat, new DeserializationException(String.format("Unable to deserialize request. Expected first field to be '%s', but was '%s'.", expectedField, this.input.getText()))));
                return false;
            }
            foundTokens.add(token);
        }
        if (!expectedTokens.equals(foundTokens)) {
            this.addError(new Neo4jError((Status)Status.Request.InvalidFormat, new DeserializationException(String.format("Unable to deserialize request. Expected %s, found %s.", expectedTokens, foundTokens))));
            return false;
        }
        return true;
    }

    private static enum State {
        BEFORE_OUTER_ARRAY,
        IN_BODY,
        FINISHED;

    }
}

