/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.InputPosition;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.graphdb.Result;
import org.neo4j.helpers.Exceptions;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.repr.util.RFC1123;
import org.neo4j.server.rest.transactional.AggregatingWriter;
import org.neo4j.server.rest.transactional.Neo4jJsonCodec;
import org.neo4j.server.rest.transactional.ResultDataContent;
import org.neo4j.server.rest.transactional.ResultDataContentWriter;
import org.neo4j.server.rest.transactional.TransactionStateChecker;
import org.neo4j.server.rest.transactional.TransitionalPeriodTransactionMessContainer;
import org.neo4j.server.rest.transactional.error.Neo4jError;

public class ExecutionResultSerializer {
    private State currentState = State.EMPTY;
    private static final JsonFactory JSON_FACTORY = new JsonFactory().disable(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM);
    private final JsonGenerator out;
    private final URI baseUri;
    private final Log log;
    private final TransitionalPeriodTransactionMessContainer container;

    public ExecutionResultSerializer(OutputStream output, URI baseUri, LogProvider logProvider, TransitionalPeriodTransactionMessContainer container) {
        this.baseUri = baseUri;
        this.log = logProvider.getLog(this.getClass());
        this.container = container;
        JSON_FACTORY.setCodec((ObjectCodec)new Neo4jJsonCodec(container));
        JsonGenerator generator = null;
        try {
            generator = JSON_FACTORY.createJsonGenerator(output);
        }
        catch (IOException e) {
            this.loggedIOException(e);
        }
        this.out = generator;
    }

    public void transactionCommitUri(URI commitUri) {
        try {
            this.ensureDocumentOpen();
            this.out.writeStringField("commit", commitUri.toString());
        }
        catch (IOException e) {
            this.loggedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void statementResult(Result result, boolean includeStats, ResultDataContent ... resultDataContents) throws IOException {
        try {
            this.ensureResultsFieldOpen();
            this.out.writeStartObject();
            try {
                List columns = result.columns();
                this.writeColumns(columns);
                this.writeRows(columns, result, this.configureWriters(resultDataContents));
                if (includeStats) {
                    this.writeStats(result.getQueryStatistics());
                }
                if (result.getQueryExecutionType().requestedExecutionPlanDescription()) {
                    this.writeRootPlanDescription(result.getExecutionPlanDescription());
                }
            }
            finally {
                this.out.writeEndObject();
            }
        }
        catch (IOException e) {
            throw this.loggedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifications(Iterable<Notification> notifications) throws IOException {
        if (!notifications.iterator().hasNext()) {
            return;
        }
        try {
            this.ensureResultsFieldClosed();
            this.out.writeArrayFieldStart("notifications");
            try {
                for (Notification notification : notifications) {
                    this.out.writeStartObject();
                    try {
                        this.out.writeStringField("code", notification.getCode());
                        this.out.writeStringField("severity", notification.getSeverity().toString());
                        this.out.writeStringField("title", notification.getTitle());
                        this.out.writeStringField("description", notification.getDescription());
                        this.writePosition(notification.getPosition());
                    }
                    finally {
                        this.out.writeEndObject();
                    }
                }
            }
            finally {
                this.out.writeEndArray();
            }
        }
        catch (IOException e) {
            throw this.loggedIOException(e);
        }
    }

    private void writePosition(InputPosition position) throws IOException {
        if (position == InputPosition.empty) {
            return;
        }
        this.out.writeObjectFieldStart("position");
        try {
            this.out.writeNumberField("offset", position.getOffset());
            this.out.writeNumberField("line", position.getLine());
            this.out.writeNumberField("column", position.getColumn());
        }
        finally {
            this.out.writeEndObject();
        }
    }

    private void writeStats(QueryStatistics stats) throws IOException {
        this.out.writeObjectFieldStart("stats");
        try {
            this.out.writeBooleanField("contains_updates", stats.containsUpdates());
            this.out.writeNumberField("nodes_created", stats.getNodesCreated());
            this.out.writeNumberField("nodes_deleted", stats.getNodesDeleted());
            this.out.writeNumberField("properties_set", stats.getPropertiesSet());
            this.out.writeNumberField("relationships_created", stats.getRelationshipsCreated());
            this.out.writeNumberField("relationship_deleted", stats.getRelationshipsDeleted());
            this.out.writeNumberField("labels_added", stats.getLabelsAdded());
            this.out.writeNumberField("labels_removed", stats.getLabelsRemoved());
            this.out.writeNumberField("indexes_added", stats.getIndexesAdded());
            this.out.writeNumberField("indexes_removed", stats.getIndexesRemoved());
            this.out.writeNumberField("constraints_added", stats.getConstraintsAdded());
            this.out.writeNumberField("constraints_removed", stats.getConstraintsRemoved());
        }
        finally {
            this.out.writeEndObject();
        }
    }

    private void writeRootPlanDescription(ExecutionPlanDescription planDescription) throws IOException {
        this.out.writeObjectFieldStart("plan");
        try {
            this.out.writeObjectFieldStart("root");
            try {
                this.writePlanDescriptionObjectBody(planDescription);
            }
            finally {
                this.out.writeEndObject();
            }
        }
        finally {
            this.out.writeEndObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePlanDescriptionObjectBody(ExecutionPlanDescription planDescription) throws IOException {
        this.out.writeStringField("operatorType", planDescription.getName());
        this.writePlanArgs(planDescription);
        this.writePlanIdentifiers(planDescription);
        List children = planDescription.getChildren();
        this.out.writeArrayFieldStart("children");
        try {
            for (ExecutionPlanDescription child : children) {
                this.out.writeStartObject();
                try {
                    this.writePlanDescriptionObjectBody(child);
                }
                finally {
                    this.out.writeEndObject();
                }
            }
        }
        finally {
            this.out.writeEndArray();
        }
    }

    private void writePlanArgs(ExecutionPlanDescription planDescription) throws IOException {
        for (Map.Entry entry : planDescription.getArguments().entrySet()) {
            String fieldName = (String)entry.getKey();
            Object fieldValue = entry.getValue();
            this.out.writeFieldName(fieldName);
            JsonHelper.writeValue(this.out, fieldValue);
        }
    }

    private void writePlanIdentifiers(ExecutionPlanDescription planDescription) throws IOException {
        this.out.writeArrayFieldStart("identifiers");
        for (String id : planDescription.getIdentifiers()) {
            this.out.writeString(id);
        }
        this.out.writeEndArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void errors(Iterable<? extends Neo4jError> errors) {
        try {
            this.ensureDocumentOpen();
            this.ensureResultsFieldClosed();
            this.out.writeArrayFieldStart("errors");
            try {
                for (Neo4jError neo4jError : errors) {
                    try {
                        this.out.writeStartObject();
                        this.out.writeObjectField("code", (Object)neo4jError.status().code().serialize());
                        this.out.writeObjectField("message", (Object)neo4jError.getMessage());
                        if (!neo4jError.shouldSerializeStackTrace()) continue;
                        this.out.writeObjectField("stackTrace", (Object)neo4jError.getStackTraceAsString());
                    }
                    finally {
                        this.out.writeEndObject();
                    }
                }
            }
            finally {
                this.out.writeEndArray();
                this.currentState = State.ERRORS_WRITTEN;
            }
        }
        catch (IOException e) {
            this.loggedIOException(e);
        }
    }

    public void transactionStatus(long expiryDate) {
        try {
            this.ensureDocumentOpen();
            this.ensureResultsFieldClosed();
            this.out.writeObjectFieldStart("transaction");
            this.out.writeStringField("expires", RFC1123.formatDate(new Date(expiryDate)));
            this.out.writeEndObject();
        }
        catch (IOException e) {
            this.loggedIOException(e);
        }
    }

    public void finish() {
        try {
            this.ensureDocumentOpen();
            if (this.currentState != State.ERRORS_WRITTEN) {
                this.errors(Collections.emptyList());
            }
            this.out.writeEndObject();
            this.out.flush();
        }
        catch (IOException e) {
            this.loggedIOException(e);
        }
    }

    private ResultDataContentWriter configureWriters(ResultDataContent[] specifiers) {
        if (specifiers == null || specifiers.length == 0) {
            return ResultDataContent.row.writer(this.baseUri);
        }
        if (specifiers.length == 1) {
            return specifiers[0].writer(this.baseUri);
        }
        ResultDataContentWriter[] writers = new ResultDataContentWriter[specifiers.length];
        for (int i = 0; i < specifiers.length; ++i) {
            writers[i] = specifiers[i].writer(this.baseUri);
        }
        return new AggregatingWriter(writers);
    }

    private void ensureDocumentOpen() throws IOException {
        if (this.currentState == State.EMPTY) {
            this.out.writeStartObject();
            this.currentState = State.DOCUMENT_OPEN;
        }
    }

    private void ensureResultsFieldOpen() throws IOException {
        this.ensureDocumentOpen();
        if (this.currentState == State.DOCUMENT_OPEN) {
            this.out.writeArrayFieldStart("results");
            this.currentState = State.RESULTS_OPEN;
        }
    }

    private void ensureResultsFieldClosed() throws IOException {
        this.ensureResultsFieldOpen();
        if (this.currentState == State.RESULTS_OPEN) {
            this.out.writeEndArray();
            this.currentState = State.RESULTS_CLOSED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRows(Iterable<String> columns, Result data, ResultDataContentWriter writer) throws IOException {
        this.out.writeArrayFieldStart("data");
        try {
            data.accept(row -> {
                this.out.writeStartObject();
                try (TransactionStateChecker txStateChecker = TransactionStateChecker.create(this.container);){
                    writer.write(this.out, columns, row, txStateChecker);
                }
                finally {
                    this.out.writeEndObject();
                }
                return true;
            });
        }
        finally {
            this.out.writeEndArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeColumns(Iterable<String> columns) throws IOException {
        try {
            this.out.writeArrayFieldStart("columns");
            for (String key : columns) {
                this.out.writeString(key);
            }
        }
        finally {
            this.out.writeEndArray();
        }
    }

    private IOException loggedIOException(IOException exception) {
        if (Exceptions.contains((Throwable)exception, (String)"Broken pipe", (Class[])new Class[]{IOException.class})) {
            this.log.error("Unable to reply to request, because the client has closed the connection (Broken pipe).");
        } else {
            this.log.error("Failed to generate JSON output.", (Throwable)exception);
        }
        return exception;
    }

    private static enum State {
        EMPTY,
        DOCUMENT_OPEN,
        RESULTS_OPEN,
        RESULTS_CLOSED,
        ERRORS_WRITTEN;

    }
}

