/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.net.URI;
import java.util.Collections;
import org.neo4j.graphdb.facade.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.server.AbstractNeoServer;
import org.neo4j.server.NeoServer;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.GraphFactory;
import org.neo4j.server.database.LifecycleManagingDatabase;
import org.neo4j.server.exception.ServerStartupErrors;
import org.neo4j.server.plugins.DisabledPluginManager;
import org.neo4j.server.plugins.PluginManager;
import org.neo4j.server.rest.management.AdvertisableService;
import org.neo4j.server.rest.transactional.DisabledTransactionRegistry;
import org.neo4j.server.rest.transactional.TransactionRegistry;

public class DisabledNeoServer
implements NeoServer {
    private final Database db;
    private final Config config;
    private final LifeSupport life = new LifeSupport();

    public DisabledNeoServer(GraphFactory graphFactory, GraphDatabaseFacadeFactory.Dependencies dependencies, Config config) {
        this.db = new LifecycleManagingDatabase(config, graphFactory, dependencies);
        this.config = config;
        this.life.add((Lifecycle)this.db);
        dependencies.userLogProvider().getLog(this.getClass()).info(AbstractNeoServer.NEO4J_IS_STARTING_MESSAGE);
    }

    @Override
    public void start() {
        try {
            this.life.start();
        }
        catch (Throwable t) {
            this.life.shutdown();
            throw ServerStartupErrors.translateToServerStartupError(t);
        }
    }

    @Override
    public void stop() {
        this.life.stop();
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public Database getDatabase() {
        return this.db;
    }

    @Override
    public TransactionRegistry getTransactionRegistry() {
        return DisabledTransactionRegistry.INSTANCE;
    }

    @Override
    public PluginManager getExtensionManager() {
        return DisabledPluginManager.INSTANCE;
    }

    @Override
    public URI baseUri() {
        throw new UnsupportedOperationException("Neo4j server is disabled");
    }

    @Override
    public Iterable<AdvertisableService> getServices() {
        return Collections.emptyList();
    }
}

