/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.server.rest.repr.EntityRepresentation;
import org.neo4j.server.rest.repr.ExtensibleRepresentation;
import org.neo4j.server.rest.repr.IndexRepresentation;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.NodeRepresentation;
import org.neo4j.server.rest.repr.RelationshipRepresentation;
import org.neo4j.server.rest.repr.ValueRepresentation;

public final class IndexedEntityRepresentation
extends MappingRepresentation
implements ExtensibleRepresentation,
EntityRepresentation {
    private final MappingRepresentation entity;
    private final ValueRepresentation selfUri;

    public IndexedEntityRepresentation(Node node, String key, String value, IndexRepresentation indexRepresentation) {
        this(new NodeRepresentation(node), node.getId(), key, value, indexRepresentation);
    }

    public IndexedEntityRepresentation(Relationship rel, String key, String value, IndexRepresentation indexRepresentation) {
        this(new RelationshipRepresentation(rel), rel.getId(), key, value, indexRepresentation);
    }

    private IndexedEntityRepresentation(MappingRepresentation entity, long entityId, String key, String value, IndexRepresentation indexRepresentation) {
        super(entity.type);
        this.entity = entity;
        this.selfUri = ValueRepresentation.uri((String)indexRepresentation.relativeUriFor(key, value, entityId));
    }

    public String getIdentity() {
        return ((ExtensibleRepresentation)this.entity).getIdentity();
    }

    @Override
    public ValueRepresentation selfUri() {
        return this.selfUri;
    }

    protected void serialize(MappingSerializer serializer) {
        this.entity.serialize(serializer);
        this.selfUri().putTo(serializer, "indexed");
    }
}

