/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.server.plugins.ParameterDescriptionConsumer;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.ObjectRepresentation;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.ValueRepresentation;

public final class ExtensionPointRepresentation
extends ObjectRepresentation
implements ParameterDescriptionConsumer {
    private final RepresentationType extended;
    private final String name;
    private final String description;
    private final List<ParameterRepresentation> parameters = new ArrayList<ParameterRepresentation>();

    public ExtensionPointRepresentation(String name, Class<?> extended, String description) {
        super(RepresentationType.PLUGIN_DESCRIPTION);
        this.name = name;
        this.description = description;
        this.extended = RepresentationType.extended(extended);
    }

    public void describeParameter(String name, Class<?> type, boolean optional, String description) {
        this.parameters.add(new ParameterRepresentation(name, type, optional, description, false));
    }

    public void describeListParameter(String name, Class<?> type, boolean optional, String description) {
        this.parameters.add(new ParameterRepresentation(name, type, optional, description, true));
    }

    public String getName() {
        return this.name;
    }

    public String getExtendedEntity() {
        return this.extended.valueName;
    }

    @ObjectRepresentation.Mapping(value="name")
    public ValueRepresentation methodName() {
        return ValueRepresentation.string((String)this.name);
    }

    @ObjectRepresentation.Mapping(value="description")
    public ValueRepresentation description() {
        return ValueRepresentation.string((String)this.description);
    }

    @ObjectRepresentation.Mapping(value="extends")
    public ValueRepresentation extendedEntity() {
        return ValueRepresentation.string((String)this.getExtendedEntity());
    }

    @ObjectRepresentation.Mapping(value="parameters")
    public ListRepresentation parametersList() {
        return new ListRepresentation(RepresentationType.PLUGIN_PARAMETER, this.parameters);
    }

    private static class ParameterRepresentation
    extends MappingRepresentation {
        private final String name;
        private final RepresentationType paramType;
        private final String description;
        private final boolean optional;
        private final boolean list;

        ParameterRepresentation(String name, Class<?> type, boolean optional, String description, boolean list) {
            super(RepresentationType.PLUGIN_PARAMETER);
            this.name = name;
            this.optional = optional;
            this.list = list;
            this.paramType = RepresentationType.extended(type);
            this.description = description;
        }

        protected void serialize(MappingSerializer serializer) {
            serializer.putString("name", this.name);
            serializer.putString("type", this.list ? this.paramType.listName : this.paramType.valueName);
            serializer.putBoolean("optional", this.optional);
            serializer.putString("description", this.description);
        }
    }
}

