/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.plugins.DefaultPluginManager;
import org.neo4j.server.plugins.PluginManager;
import org.neo4j.server.rest.web.BatchOperationService;
import org.neo4j.server.rest.web.CollectUserAgentFilter;
import org.neo4j.server.rest.web.CorsFilter;
import org.neo4j.server.rest.web.CypherService;
import org.neo4j.server.rest.web.DatabaseMetadataService;
import org.neo4j.server.rest.web.ExtensionService;
import org.neo4j.server.rest.web.RestfulGraphDatabase;
import org.neo4j.server.rest.web.TransactionalService;
import org.neo4j.server.web.WebServer;
import org.neo4j.udc.UsageData;
import org.neo4j.udc.UsageDataKeys;
import org.neo4j.util.concurrent.RecentK;

public class RESTApiModule
implements ServerModule {
    private final Config config;
    private final WebServer webServer;
    private final Supplier<UsageData> userDataSupplier;
    private final LogProvider logProvider;
    private PluginManager plugins;

    public RESTApiModule(WebServer webServer, Config config, Supplier<UsageData> userDataSupplier, LogProvider logProvider) {
        this.webServer = webServer;
        this.config = config;
        this.userDataSupplier = userDataSupplier;
        this.logProvider = logProvider;
    }

    @Override
    public void start() {
        URI restApiUri = this.restApiUri();
        this.webServer.addFilter(new CollectUserAgentFilter(this.clientNames()), "/*");
        this.webServer.addFilter(new CorsFilter(this.logProvider, (String)this.config.get(ServerSettings.http_access_control_allow_origin)), "/*");
        this.webServer.addJAXRSClasses(this.getClassNames(), restApiUri.toString(), null);
        this.loadPlugins();
    }

    private RecentK<String> clientNames() {
        return (RecentK)this.userDataSupplier.get().get(UsageDataKeys.clientNames);
    }

    private List<String> getClassNames() {
        return Arrays.asList(RestfulGraphDatabase.class.getName(), TransactionalService.class.getName(), CypherService.class.getName(), DatabaseMetadataService.class.getName(), ExtensionService.class.getName(), BatchOperationService.class.getName());
    }

    @Override
    public void stop() {
        this.webServer.removeJAXRSClasses(this.getClassNames(), this.restApiUri().toString());
    }

    private URI restApiUri() {
        return (URI)this.config.get(ServerSettings.rest_api_path);
    }

    private void loadPlugins() {
        this.plugins = new DefaultPluginManager(this.logProvider);
    }

    public PluginManager getPlugins() {
        return this.plugins;
    }
}

