/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import java.net.SocketAddress;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnection;
import org.neo4j.kernel.api.net.TrackedNetworkConnection;

public class JettyHttpConnection
extends HttpConnection
implements TrackedNetworkConnection {
    private final String id;
    private final long connectTime;
    private volatile String username;
    private volatile String userAgent;

    public JettyHttpConnection(String id, HttpConfiguration config, Connector connector, EndPoint endPoint, HttpCompliance compliance, boolean recordComplianceViolations) {
        super(config, connector, endPoint, compliance, recordComplianceViolations);
        this.id = id;
        this.connectTime = System.currentTimeMillis();
    }

    public String id() {
        return this.id;
    }

    public long connectTime() {
        return this.connectTime;
    }

    public String connector() {
        return this.getConnector().getName();
    }

    public SocketAddress serverAddress() {
        return this.getEndPoint().getLocalAddress();
    }

    public SocketAddress clientAddress() {
        return this.getEndPoint().getRemoteAddress();
    }

    public String username() {
        return this.username;
    }

    public String userAgent() {
        return this.userAgent;
    }

    public void updateUser(String username, String userAgent) {
        this.username = username;
        this.userAgent = userAgent;
    }

    public static void updateUserForCurrentConnection(String username, String userAgent) {
        JettyHttpConnection connection = JettyHttpConnection.getCurrentJettyHttpConnection();
        if (connection != null) {
            connection.updateUser(username, userAgent);
        }
    }

    public static JettyHttpConnection getCurrentJettyHttpConnection() {
        HttpConnection connection = HttpConnection.getCurrentConnection();
        return connection instanceof JettyHttpConnection ? (JettyHttpConnection)connection : null;
    }
}

