/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.neo4j.concurrent.RecentK;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.plugins.PluginManager;
import org.neo4j.server.rest.web.BatchOperationService;
import org.neo4j.server.rest.web.CollectUserAgentFilter;
import org.neo4j.server.rest.web.CorsFilter;
import org.neo4j.server.rest.web.CypherService;
import org.neo4j.server.rest.web.DatabaseMetadataService;
import org.neo4j.server.rest.web.ExtensionService;
import org.neo4j.server.rest.web.ResourcesService;
import org.neo4j.server.rest.web.RestfulGraphDatabase;
import org.neo4j.server.rest.web.TransactionalService;
import org.neo4j.server.web.WebServer;
import org.neo4j.udc.UsageData;
import org.neo4j.udc.UsageDataKeys;

public class RESTApiModule
implements ServerModule {
    private final Config config;
    private final WebServer webServer;
    private DependencyResolver dependencyResolver;
    private final LogProvider logProvider;
    private PluginManager plugins;

    public RESTApiModule(WebServer webServer, Config config, DependencyResolver dependencyResolver, LogProvider logProvider) {
        this.webServer = webServer;
        this.config = config;
        this.dependencyResolver = dependencyResolver;
        this.logProvider = logProvider;
    }

    @Override
    public void start() {
        URI restApiUri = this.restApiUri();
        this.webServer.addFilter(new CollectUserAgentFilter(this.clientNames()), "/*");
        this.webServer.addFilter(new CorsFilter(this.logProvider), "/*");
        this.webServer.addJAXRSClasses(this.getClassNames(), restApiUri.toString(), null);
        this.loadPlugins();
    }

    private RecentK<String> clientNames() {
        return (RecentK)((UsageData)this.dependencyResolver.resolveDependency(UsageData.class)).get(UsageDataKeys.clientNames);
    }

    private List<String> getClassNames() {
        return Arrays.asList(RestfulGraphDatabase.class.getName(), TransactionalService.class.getName(), CypherService.class.getName(), DatabaseMetadataService.class.getName(), ExtensionService.class.getName(), ResourcesService.class.getName(), BatchOperationService.class.getName());
    }

    @Override
    public void stop() {
        this.webServer.removeJAXRSClasses(this.getClassNames(), this.restApiUri().toString());
        this.unloadPlugins();
    }

    private URI restApiUri() {
        return (URI)this.config.get(ServerSettings.rest_api_path);
    }

    private void loadPlugins() {
        this.plugins = new PluginManager(this.config, this.logProvider);
    }

    private void unloadPlugins() {
    }

    public PluginManager getPlugins() {
        return this.plugins;
    }
}

