/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr.formats;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.neo4j.server.rest.domain.HtmlHelper;
import org.neo4j.server.rest.repr.BadInputException;
import org.neo4j.server.rest.repr.ListWriter;
import org.neo4j.server.rest.repr.MappingWriter;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.formats.ListWrappingWriter;
import org.neo4j.server.rest.repr.formats.MapWrappingWriter;

public class HtmlFormat
extends RepresentationFormat {
    public HtmlFormat() {
        super(MediaType.TEXT_HTML_TYPE);
    }

    private static void transfer(Map<?, ?> from, Map<Object, Object> to, String ... keys) {
        for (String key : keys) {
            Object value = from.get(key);
            if (value == null) continue;
            to.put(key, value);
        }
    }

    private static String renderIndex(Map<String, Object> serialized) {
        String javascript = "";
        StringBuilder builder = HtmlHelper.start(HtmlHelper.ObjectType.INDEX_ROOT, javascript);
        int counter = 0;
        for (String indexName : serialized.keySet()) {
            Map indexMapObject = (Map)serialized.get(indexName);
            builder.append("<ul>");
            builder.append("<li>");
            Map indexMap = indexMapObject;
            String keyId = "key_" + counter;
            String valueId = "value_" + counter;
            builder.append("<form action='javascript:neo4jHtmlBrowse.search(\"").append(indexMap.get("template")).append("\",\"").append(keyId).append("\",\"").append(valueId).append("\");'><fieldset><legend> name: ").append(indexName).append(" (configuration: ").append(indexMap.get("type")).append(")</legend>\n");
            builder.append("<label for='").append(keyId).append("'>Key</label><input id='").append(keyId).append("'>\n");
            builder.append("<label for='").append(valueId).append("'>Value</label><input id='").append(valueId).append("'>\n");
            builder.append("<button>Search</button>\n");
            builder.append("</fieldset></form>\n");
            builder.append("</li>\n");
            ++counter;
            builder.append("</ul>");
        }
        return HtmlHelper.end(builder);
    }

    protected String complete(ListWriter serializer) {
        return ((HtmlList)serializer).complete();
    }

    protected String complete(MappingWriter serializer) {
        return ((HtmlMap)serializer).complete();
    }

    protected ListWriter serializeList(String type) {
        if (Representation.NODE_LIST.equals(type)) {
            return new HtmlList(ListTemplate.NODES);
        }
        if (Representation.RELATIONSHIP_LIST.equals(type)) {
            return new HtmlList(ListTemplate.RELATIONSHIPS);
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).entity((Object)("Cannot represent \"" + type + "\" as html")).build());
    }

    protected MappingWriter serializeMapping(String type) {
        MappingTemplate template = MappingTemplate.TEMPLATES.get(type);
        if (template == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).entity((Object)("Cannot represent \"" + type + "\" as html")).build());
        }
        return new HtmlMap(template);
    }

    protected String serializeValue(String type, Object value) {
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).entity((Object)("Cannot represent \"" + type + "\" as html")).build());
    }

    public List<Object> readList(String input) throws BadInputException {
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNSUPPORTED_MEDIA_TYPE).entity((Object)"Cannot read html").build());
    }

    public Map<String, Object> readMap(String input, String ... requiredKeys) throws BadInputException {
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNSUPPORTED_MEDIA_TYPE).entity((Object)"Cannot read html").build());
    }

    public URI readUri(String input) throws BadInputException {
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNSUPPORTED_MEDIA_TYPE).entity((Object)"Cannot read html").build());
    }

    public Object readValue(String input) throws BadInputException {
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNSUPPORTED_MEDIA_TYPE).entity((Object)"Cannot read html").build());
    }

    private static class HtmlList
    extends ListWrappingWriter {
        private final ListTemplate template;

        HtmlList(ListTemplate template) {
            super(new ArrayList<Object>(), true);
            this.template = template;
        }

        String complete() {
            return this.template.render(this.data);
        }
    }

    private static class HtmlMap
    extends MapWrappingWriter {
        private final MappingTemplate template;

        HtmlMap(MappingTemplate template) {
            super(new HashMap<String, Object>(), true);
            this.template = template;
        }

        String complete() {
            return this.template.render(this.data);
        }
    }

    private static enum ListTemplate {
        NODES{

            @Override
            String render(List<Object> data) {
                StringBuilder builder = HtmlHelper.start("Index hits", null);
                if (data.isEmpty()) {
                    HtmlHelper.appendMessage(builder, "No index hits");
                    return HtmlHelper.end(builder);
                }
                for (Map map : data) {
                    LinkedHashMap map2 = new LinkedHashMap();
                    HtmlFormat.transfer(map, map2, new String[]{"self", "data"});
                    HtmlHelper.append(builder, map2, HtmlHelper.ObjectType.NODE);
                }
                return HtmlHelper.end(builder);
            }
        }
        ,
        RELATIONSHIPS{

            @Override
            String render(List<Object> data) {
                if (data.isEmpty()) {
                    StringBuilder builder = HtmlHelper.start(HtmlHelper.ObjectType.RELATIONSHIP, null);
                    HtmlHelper.appendMessage(builder, "No relationships found");
                    return HtmlHelper.end(builder);
                }
                ArrayList list = new ArrayList();
                for (Map map : data) {
                    LinkedHashMap map2 = new LinkedHashMap();
                    HtmlFormat.transfer(map, map2, new String[]{"self", "type", "data", "start", "end"});
                    list.add(map2);
                }
                return HtmlHelper.from(list, HtmlHelper.ObjectType.RELATIONSHIP);
            }
        };


        abstract String render(List<Object> var1);
    }

    private static enum MappingTemplate {
        NODE(Representation.NODE){

            @Override
            String render(Map<String, Object> serialized) {
                String javascript = "";
                StringBuilder builder = HtmlHelper.start(HtmlHelper.ObjectType.NODE, javascript);
                HtmlHelper.append(builder, Collections.singletonMap("data", serialized.get("data")), HtmlHelper.ObjectType.NODE);
                builder.append("<form action='javascript:neo4jHtmlBrowse.getRelationships();'>");
                builder.append("<fieldset><legend>Get relationships</legend>\n");
                builder.append("<label for='direction'>with direction</label>\n<select id='direction'>");
                builder.append("<option value='").append(serialized.get("all_typed_relationships")).append("'>all</option>");
                builder.append("<option value='").append(serialized.get("incoming_typed_relationships")).append("'>in</option>");
                builder.append("<option value='").append(serialized.get("outgoing_typed_relationships")).append("'>out</option>");
                builder.append("</select>\n");
                builder.append("<label for='types'>for type(s)</label><select id='types' multiple='multiple'>");
                for (String relationshipType : (List)serialized.get("relationship_types")) {
                    builder.append("<option selected='selected' value='").append(relationshipType).append("'>");
                    builder.append(relationshipType).append("</option>");
                }
                builder.append("</select>\n");
                builder.append("<button>Get</button>\n");
                builder.append("</fieldset></form>\n");
                return HtmlHelper.end(builder);
            }
        }
        ,
        RELATIONSHIP(Representation.RELATIONSHIP){

            @Override
            String render(Map<String, Object> serialized) {
                LinkedHashMap map = new LinkedHashMap();
                HtmlFormat.transfer(serialized, map, new String[]{"type", "data", "start", "end"});
                return HtmlHelper.from(map, HtmlHelper.ObjectType.RELATIONSHIP);
            }
        }
        ,
        NODE_INDEXES(Representation.NODE_INDEXES){

            @Override
            String render(Map<String, Object> serialized) {
                return HtmlFormat.renderIndex(serialized);
            }
        }
        ,
        RELATIONSHIP_INDEXES(Representation.RELATIONSHIP_INDEXES){

            @Override
            String render(Map<String, Object> serialized) {
                return HtmlFormat.renderIndex(serialized);
            }
        }
        ,
        GRAPHDB(Representation.GRAPHDB){

            @Override
            String render(Map<String, Object> serialized) {
                HashMap map = new HashMap();
                HtmlFormat.transfer(serialized, map, new String[]{"index", "node_index", "relationship_index"});
                return HtmlHelper.from(map, HtmlHelper.ObjectType.ROOT);
            }
        }
        ,
        EXCEPTION(Representation.EXCEPTION){

            @Override
            String render(Map<String, Object> serialized) {
                StringBuilder entity = new StringBuilder("<html>");
                entity.append("<head><title>Error</title></head><body>");
                Object subjectOrNull = serialized.get("message");
                if (subjectOrNull != null) {
                    entity.append("<p><pre>").append(subjectOrNull).append("</pre></p>");
                }
                entity.append("<p><pre>").append(serialized.get("exception"));
                List tb = (List)serialized.get("stackTrace");
                if (tb != null) {
                    for (Object el : tb) {
                        entity.append("\n\tat " + el);
                    }
                }
                entity.append("</pre></p>").append("</body></html>");
                return entity.toString();
            }
        };

        private final String key;
        static final Map<String, MappingTemplate> TEMPLATES;

        private MappingTemplate(String key) {
            this.key = key;
        }

        abstract String render(Map<String, Object> var1);

        static {
            TEMPLATES = new HashMap<String, MappingTemplate>();
            for (MappingTemplate template : MappingTemplate.values()) {
                TEMPLATES.put(template.key, template);
            }
        }
    }
}

