/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.database;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.neo4j.cypher.internal.javacompat.ExecutionEngine;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.PropertyContainerLocker;
import org.neo4j.kernel.impl.query.Neo4jTransactionalContextFactory;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.database.Database;
import org.neo4j.server.rest.web.HttpConnectionInfoFactory;
import org.neo4j.server.web.HttpHeaderUtils;

public class CypherExecutor
extends LifecycleAdapter {
    private final Database database;
    private final Log log;
    private ExecutionEngine executionEngine;
    private TransactionalContextFactory contextFactory;
    private static final PropertyContainerLocker locker = new PropertyContainerLocker();
    private GraphDatabaseQueryService service;

    public CypherExecutor(Database database, LogProvider logProvider) {
        this.database = database;
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
    }

    public ExecutionEngine getExecutionEngine() {
        return this.executionEngine;
    }

    public void start() throws Throwable {
        DependencyResolver resolver = this.database.getGraph().getDependencyResolver();
        this.executionEngine = (ExecutionEngine)resolver.resolveDependency(QueryExecutionEngine.class);
        this.service = (GraphDatabaseQueryService)resolver.resolveDependency(GraphDatabaseQueryService.class);
        this.contextFactory = Neo4jTransactionalContextFactory.create((GraphDatabaseQueryService)this.service, (PropertyContainerLocker)locker);
    }

    public void stop() throws Throwable {
        this.executionEngine = null;
        this.contextFactory = null;
    }

    public TransactionalContext createTransactionContext(String query, Map<String, Object> parameters, HttpServletRequest request) {
        InternalTransaction tx = this.getInternalTransaction(request);
        return this.contextFactory.newContext(HttpConnectionInfoFactory.create(request), tx, query, parameters);
    }

    private InternalTransaction getInternalTransaction(HttpServletRequest request) {
        long customTimeout = HttpHeaderUtils.getTransactionTimeout(request, this.log);
        return customTimeout > 0L ? this.beginCustomTransaction(customTimeout) : this.beginDefaultTransaction();
    }

    private InternalTransaction beginCustomTransaction(long customTimeout) {
        return this.service.beginTransaction(KernelTransaction.Type.implicit, SecurityContext.AUTH_DISABLED, customTimeout, TimeUnit.MILLISECONDS);
    }

    private InternalTransaction beginDefaultTransaction() {
        return this.service.beginTransaction(KernelTransaction.Type.implicit, SecurityContext.AUTH_DISABLED);
    }
}

