/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import javax.servlet.http.HttpServletRequest;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.PropertyContainerLocker;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.query.Neo4jTransactionalContext;
import org.neo4j.kernel.impl.query.QuerySession;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.server.rest.transactional.TransitionalTxManagementKernelTransaction;
import org.neo4j.server.rest.web.ServerQuerySession;

public class TransitionalPeriodTransactionMessContainer {
    private static final PropertyContainerLocker locker = new PropertyContainerLocker();
    private final GraphDatabaseFacade db;
    private final ThreadToStatementContextBridge txBridge;

    public TransitionalPeriodTransactionMessContainer(GraphDatabaseFacade db) {
        this.db = db;
        this.txBridge = (ThreadToStatementContextBridge)db.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
    }

    public TransitionalTxManagementKernelTransaction newTransaction(KernelTransaction.Type type, AccessMode mode, long customTransactionTimeout) {
        return new TransitionalTxManagementKernelTransaction(this.db, type, mode, customTransactionTimeout, this.txBridge);
    }

    public ThreadToStatementContextBridge getBridge() {
        return this.txBridge;
    }

    public QuerySession create(GraphDatabaseQueryService service, KernelTransaction.Type type, AccessMode mode, long customTransactionTimeout, HttpServletRequest request) {
        InternalTransaction transaction = customTransactionTimeout > 0L ? this.db.beginTransaction(type, mode, customTransactionTimeout) : this.db.beginTransaction(type, mode);
        Neo4jTransactionalContext context = new Neo4jTransactionalContext(service, transaction, this.txBridge.get(), locker);
        return new ServerQuerySession(request, (TransactionalContext)context);
    }
}

