/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.database;

import javax.servlet.http.HttpServletRequest;
import org.neo4j.cypher.internal.javacompat.ExecutionEngine;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.PropertyContainerLocker;
import org.neo4j.kernel.impl.query.Neo4jTransactionalContext;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.QuerySession;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.database.Database;
import org.neo4j.server.rest.web.ServerQuerySession;
import org.neo4j.server.web.HttpHeaderUtils;

public class CypherExecutor
extends LifecycleAdapter {
    private final Database database;
    private ExecutionEngine executionEngine;
    private GraphDatabaseQueryService service;
    private ThreadToStatementContextBridge txBridge;
    private static final PropertyContainerLocker locker = new PropertyContainerLocker();
    private final boolean guardEnabled;
    private final Log log;

    public CypherExecutor(Database database, Config config, LogProvider logProvider) {
        this.database = database;
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
        this.guardEnabled = (Boolean)config.get(GraphDatabaseSettings.execution_guard_enabled);
    }

    public ExecutionEngine getExecutionEngine() {
        return this.executionEngine;
    }

    public void start() throws Throwable {
        DependencyResolver dependencyResolver = this.database.getGraph().getDependencyResolver();
        this.executionEngine = (ExecutionEngine)dependencyResolver.resolveDependency(QueryExecutionEngine.class);
        this.service = this.executionEngine.queryService();
        this.txBridge = (ThreadToStatementContextBridge)dependencyResolver.resolveDependency(ThreadToStatementContextBridge.class);
    }

    public void stop() throws Throwable {
        this.executionEngine = null;
        this.service = null;
        this.txBridge = null;
    }

    public QuerySession createSession(HttpServletRequest request) {
        InternalTransaction transaction = this.getInternalTransaction(request);
        Neo4jTransactionalContext context = new Neo4jTransactionalContext(this.service, transaction, this.txBridge.get(), locker);
        return new ServerQuerySession(request, (TransactionalContext)context);
    }

    private InternalTransaction getInternalTransaction(HttpServletRequest request) {
        long customTimeout;
        if (this.guardEnabled && (customTimeout = HttpHeaderUtils.getTransactionTimeout(request, this.log)) > 0L) {
            return this.beginCustomTransaction(customTimeout);
        }
        return this.beginDefaultTransaction();
    }

    private InternalTransaction beginCustomTransaction(long customTimeout) {
        return this.service.beginTransaction(KernelTransaction.Type.implicit, (AccessMode)AccessMode.Static.FULL, customTimeout);
    }

    private InternalTransaction beginDefaultTransaction() {
        return this.service.beginTransaction(KernelTransaction.Type.implicit, (AccessMode)AccessMode.Static.FULL);
    }
}

