/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MediaType;

public class HttpHeaderUtils {
    public static final Map<String, String> CHARSET = Collections.singletonMap("charset", StandardCharsets.UTF_8.name());

    public static MediaType mediaTypeWithCharsetUtf8(String mediaType) {
        return new MediaType(mediaType, null, CHARSET);
    }

    public static MediaType mediaTypeWithCharsetUtf8(MediaType mediaType) {
        Map parameters = mediaType.getParameters();
        if (parameters.isEmpty()) {
            return new MediaType(mediaType.getType(), mediaType.getSubtype(), CHARSET);
        }
        if (parameters.containsKey("charset")) {
            return mediaType;
        }
        HashMap<String, String> paramsWithCharset = new HashMap<String, String>(parameters);
        paramsWithCharset.putAll(CHARSET);
        return new MediaType(mediaType.getType(), mediaType.getSubtype(), paramsWithCharset);
    }
}

