/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.ssl;

import io.netty.handler.ssl.util.SelfSignedCertificate;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Collection;
import java.util.LinkedList;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.server.security.ssl.InsecureRandom;

public class Certificates {
    private static final boolean useInsecureCertificateGeneration = Boolean.getBoolean("org.neo4j.useInsecureCertificateGeneration");
    private static final String CERTIFICATE_TYPE = "X.509";
    private static final String DEFAULT_ENCRYPTION = "RSA";
    private final SecureRandom random;

    public Certificates() {
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.random = useInsecureCertificateGeneration ? new InsecureRandom() : new SecureRandom();
    }

    public void createSelfSignedCertificate(File certificatePath, File privateKeyPath, String hostName) throws GeneralSecurityException, IOException {
        SelfSignedCertificate cert = new SelfSignedCertificate(hostName, this.random, 1024);
        certificatePath.getParentFile().mkdirs();
        privateKeyPath.getParentFile().mkdirs();
        FileUtils.moveFile((File)cert.certificate(), (File)certificatePath);
        FileUtils.moveFile((File)cert.privateKey(), (File)privateKeyPath);
    }

    public Certificate[] loadCertificates(File certFile) throws CertificateException, IOException {
        CertificateFactory certFactory = CertificateFactory.getInstance(CERTIFICATE_TYPE);
        Collection<? extends Certificate> certificates = new LinkedList<Certificate>();
        try (PemReader r = new PemReader((Reader)new FileReader(certFile));){
            PemObject pemObject = r.readPemObject();
            while (pemObject != null) {
                byte[] encodedCert = pemObject.getContent();
                certificates.addAll(certFactory.generateCertificates(new ByteArrayInputStream(encodedCert)));
                pemObject = r.readPemObject();
            }
        }
        if (certificates.size() == 0) {
            var5_5 = null;
            try (FileInputStream in = new FileInputStream(certFile);){
                certificates = certFactory.generateCertificates(in);
            }
            catch (Throwable throwable) {
                var5_5 = throwable;
                throw throwable;
            }
        }
        return certificates.toArray(new Certificate[certificates.size()]);
    }

    /*
     * Loose catch block
     */
    public PrivateKey loadPrivateKey(File privateKeyFile) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        Throwable throwable;
        block39: {
            throwable = null;
            try (PemReader r = new PemReader((Reader)new FileReader(privateKeyFile));){
                PemObject pemObject2222 = r.readPemObject();
                if (pemObject2222 == null) break block39;
                byte[] encodedKey = pemObject2222.getContent();
                PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encodedKey);
                try {
                    PrivateKey privateKey = KeyFactory.getInstance(DEFAULT_ENCRYPTION).generatePrivate(keySpec);
                    return privateKey;
                }
                catch (InvalidKeySpecException ignore) {
                    PrivateKey privateKey;
                    block40: {
                        block41: {
                            privateKey = KeyFactory.getInstance("DSA").generatePrivate(keySpec);
                            if (r == null) break block40;
                            if (throwable == null) break block41;
                            try {
                                r.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            break block40;
                        }
                        r.close();
                    }
                    return privateKey;
                    {
                        catch (InvalidKeySpecException ignore2) {
                            PrivateKey privateKey2;
                            block42: {
                                block43: {
                                    privateKey2 = KeyFactory.getInstance("EC").generatePrivate(keySpec);
                                    if (r == null) break block42;
                                    if (throwable == null) break block43;
                                    try {
                                        r.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    break block42;
                                }
                                r.close();
                            }
                            return privateKey2;
                            {
                                catch (InvalidKeySpecException e) {
                                    try {
                                        throw new InvalidKeySpecException("Neither RSA, DSA nor EC worked", e);
                                    }
                                    catch (Throwable pemObject2222) {
                                        throwable = pemObject2222;
                                        throw pemObject2222;
                                    }
                                    catch (Throwable throwable4) {
                                        throw throwable4;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        throwable = null;
        try (DataInputStream in = new DataInputStream(new FileInputStream(privateKeyFile));){
            byte[] keyBytes = new byte[(int)privateKeyFile.length()];
            in.readFully(keyBytes);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
            PrivateKey privateKey = KeyFactory.getInstance(DEFAULT_ENCRYPTION).generatePrivate(keySpec);
            return privateKey;
        }
        catch (Throwable throwable5) {
            throwable = throwable5;
            throw throwable5;
        }
    }
}

