/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import java.util.Collection;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.impl.util.Converters;
import org.neo4j.kernel.impl.util.Validator;

public class ServerCommandLineArgs {
    static final String CONFIG_KEY_ALT_1 = "config";
    static final String CONFIG_KEY_ALT_2 = "C";
    private final File configFile;
    private final Pair<String, String>[] configOverrides;

    public ServerCommandLineArgs(File configFile, Pair<String, String>[] configOverrides) {
        this.configFile = configFile;
        this.configOverrides = configOverrides;
    }

    public static ServerCommandLineArgs parse(String[] argv) {
        Args args = Args.parse((String[])argv);
        return new ServerCommandLineArgs(ServerCommandLineArgs.detemineConfigFile(args), ServerCommandLineArgs.parseConfigOverrides(args));
    }

    public Pair<String, String>[] configOverrides() {
        return this.configOverrides;
    }

    public File configFile() {
        return this.configFile;
    }

    private static File detemineConfigFile(Args arguments) {
        return new File(arguments.get(CONFIG_KEY_ALT_2, arguments.get(CONFIG_KEY_ALT_1, "config/neo4j.config")));
    }

    private static Pair<String, String>[] parseConfigOverrides(Args arguments) {
        Collection options = arguments.interpretOptions("c", Converters.optional(), s -> {
            if (s.contains("=")) {
                String[] keyVal = s.split("=", 2);
                return Pair.pair((Object)keyVal[0], (Object)keyVal[1]);
            }
            return Pair.pair((Object)s, (Object)"true");
        }, new Validator[0]);
        return options.toArray(new Pair[options.size()]);
    }
}

