/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.exception;

import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.impl.storemigration.UpgradeNotAllowedByConfigurationException;
import org.neo4j.kernel.impl.storemigration.UpgradeNotAllowedByDatabaseModeException;
import org.neo4j.kernel.impl.storemigration.UpgradeNotAllowedException;
import org.neo4j.logging.Log;
import org.neo4j.server.ServerStartupException;

public class UpgradeDisallowedStartupException
extends ServerStartupException {
    public UpgradeDisallowedStartupException(UpgradeNotAllowedException cause) {
        super(cause.getMessage(), (Throwable)cause);
    }

    @Override
    public void describeTo(Log log) {
        if (this.getCause() instanceof UpgradeNotAllowedByDatabaseModeException) {
            log.error("Neo4j cannot be started, because the database files require upgrading and upgrading is not supported in this database mode. Please start the database in stand-alone mode to allow a safe upgrade of the database files.");
        } else if (this.getCause() instanceof UpgradeNotAllowedByConfigurationException) {
            log.error("Neo4j cannot be started, because the database files require upgrading and upgrades are disabled in configuration. Please set '%s' to 'true' in your configuration file and try again.", new Object[]{GraphDatabaseSettings.allow_store_upgrade.name()});
        } else {
            super.describeTo(log);
        }
    }
}

