/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.neo4j.kernel.impl.util.Charsets;
import org.neo4j.kernel.impl.util.Codecs;
import org.neo4j.server.security.auth.Credential;
import org.neo4j.server.security.auth.User;

public class UserSerialization {
    private static final String userSeparator = ":";
    private static final String credentialSeparator = ",";

    public byte[] serialize(Collection<User> users) {
        StringBuilder sb = new StringBuilder();
        for (User user : users) {
            sb.append(this.serialize(user)).append("\n");
        }
        return sb.toString().getBytes(Charsets.UTF_8);
    }

    public List<User> deserializeUsers(byte[] bytes) throws FormatException {
        ArrayList<User> out = new ArrayList<User>();
        int lineNumber = 1;
        for (String line : new String(bytes, Charsets.UTF_8).split("\n")) {
            if (line.trim().length() > 0) {
                out.add(this.deserializeUser(line, lineNumber));
            }
            ++lineNumber;
        }
        return out;
    }

    private String serialize(User user) {
        return this.join(userSeparator, user.name(), this.serialize(user.credentials()), user.passwordChangeRequired() ? "password_change_required" : "");
    }

    private User deserializeUser(String line, int lineNumber) throws FormatException {
        String[] parts = line.split(userSeparator, -1);
        if (parts.length != 3) {
            throw new FormatException(String.format("wrong number of line fields [line %d]", lineNumber));
        }
        return new User.Builder().withName(parts[0]).withCredentials(this.deserializeCredentials(parts[1], lineNumber)).withRequiredPasswordChange(parts[2].equals("password_change_required")).build();
    }

    private String serialize(Credential cred) {
        String encodedSalt = Codecs.encodeHexString((byte[])cred.salt());
        String encodedPassword = Codecs.encodeHexString((byte[])cred.passwordHash());
        return this.join(credentialSeparator, "SHA-256", encodedPassword, encodedSalt);
    }

    private Credential deserializeCredentials(String part, int lineNumber) throws FormatException {
        String[] split = part.split(credentialSeparator, -1);
        if (split.length != 3) {
            throw new FormatException(String.format("wrong number of credential fields [line %d]", lineNumber));
        }
        if (!split[0].equals("SHA-256")) {
            throw new FormatException(String.format("unknown digest \"%s\" [line %d]", split[0], lineNumber));
        }
        byte[] decodedPassword = Codecs.decodeHexString((String)split[1]);
        byte[] decodedSalt = Codecs.decodeHexString((String)split[2]);
        return new Credential(decodedSalt, decodedPassword);
    }

    private String join(String separator, String ... segments) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < segments.length; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(segments[i] == null ? "" : segments[i]);
        }
        return sb.toString();
    }

    public class FormatException
    extends Exception {
        FormatException(String message) {
            super(message);
        }
    }
}

