/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr.formats;

import java.io.IOException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class StreamingJsonUtils {
    public static String readCurrentValueAsString(JsonParser jp, JsonToken token) throws JsonParseException, IOException {
        return StreamingJsonUtils.readCurrentValueInto(jp, token, new StringBuilder()).toString();
    }

    private static StringBuilder readCurrentValueInto(JsonParser jp, JsonToken token, StringBuilder b) throws JsonParseException, IOException {
        if (token == JsonToken.START_OBJECT) {
            boolean first = true;
            b.append('{');
            while ((token = jp.nextToken()) != JsonToken.END_OBJECT && token != null) {
                if (!first) {
                    b.append(',');
                } else {
                    first = false;
                }
                b.append('\"');
                b.append(jp.getText());
                b.append('\"');
                b.append(':');
                StreamingJsonUtils.readCurrentValueInto(jp, jp.nextToken(), b);
            }
            b.append('}');
        } else if (token == JsonToken.START_ARRAY) {
            boolean first = true;
            b.append('[');
            while ((token = jp.nextToken()) != JsonToken.END_ARRAY && token != null) {
                if (!first) {
                    b.append(',');
                } else {
                    first = false;
                }
                StreamingJsonUtils.readCurrentValueInto(jp, token, b);
            }
            b.append(']');
        } else if (token == JsonToken.VALUE_STRING) {
            b.append('\"');
            b.append(jp.getText());
            b.append('\"');
        } else if (token == JsonToken.VALUE_FALSE) {
            b.append("false");
        } else if (token == JsonToken.VALUE_TRUE) {
            b.append("true");
        } else if (token == JsonToken.VALUE_NULL) {
            b.append("null");
        } else {
            b.append(jp.getText());
        }
        return b;
    }
}

