/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webadmin.console;

import com.tinkerpop.blueprints.pgm.TransactionalGraph;
import com.tinkerpop.blueprints.pgm.impls.neo4j.Neo4jGraph;
import groovy.lang.Binding;
import groovy.lang.GroovyRuntimeException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.codehaus.groovy.tools.shell.IO;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.helpers.Pair;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.DatabaseBlockedException;
import org.neo4j.server.logging.Logger;
import org.neo4j.server.webadmin.console.GremlinWebConsole;
import org.neo4j.server.webadmin.console.ScriptSession;

public class GremlinSession
implements ScriptSession {
    private static final String INIT_FUNCTION = "init()";
    private static final Logger log = Logger.getLogger(GremlinSession.class);
    protected GremlinWebConsole scriptEngine;
    private final Database database;
    private final IO io;
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private final List<String> initialBindings;

    public GremlinSession(Database database) {
        this.database = database;
        PrintStream out = new PrintStream(new BufferedOutputStream(this.baos));
        this.io = new IO(System.in, (OutputStream)out, (OutputStream)out);
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        bindings.put("g", this.getGremlinWrappedGraph());
        bindings.put("out", out);
        this.initialBindings = new ArrayList(bindings.keySet());
        try {
            this.scriptEngine = new GremlinWebConsole(new Binding(bindings), this.io);
        }
        catch (Exception failure) {
            this.scriptEngine = new GremlinWebConsole(){

                @Override
                public void execute(String script) {
                    ((GremlinSession)GremlinSession.this).io.out.println("Could not start Groovy during Gremlin initialization, reason:");
                    failure.printStackTrace(((GremlinSession)GremlinSession.this).io.out);
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pair<String, String> evaluate(String script) {
        String result;
        block6: {
            result = null;
            try {
                if (script.equals(INIT_FUNCTION)) {
                    result = this.init();
                    break block6;
                }
                try {
                    this.scriptEngine.execute(script);
                    result = this.baos.toString();
                }
                finally {
                    this.resetIO();
                }
            }
            catch (GroovyRuntimeException ex) {
                log.error(ex);
                result = ex.getMessage();
            }
        }
        return Pair.of((Object)result, null);
    }

    private String init() {
        StringBuffer out = new StringBuffer();
        out.append("\n");
        out.append("         \\,,,/\n");
        out.append("         (o o)\n");
        out.append("-----oOOo-(_)-oOOo-----\n");
        out.append("\n");
        out.append("Available variables:\n");
        for (String variable : this.initialBindings) {
            out.append("  " + variable + "\t= ");
            out.append(this.evaluate(variable));
        }
        out.append("\n");
        return out.toString();
    }

    private void resetIO() {
        this.baos.reset();
    }

    private TransactionalGraph getGremlinWrappedGraph() throws DatabaseBlockedException {
        return new Neo4jGraph((GraphDatabaseService)this.database.graph, false);
    }
}

