/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.neo4j.server.logging.Logger;

public class CollectUserAgentFilter
implements ContainerRequestFilter {
    private static final Logger log = Logger.getLogger(CollectUserAgentFilter.class);
    private static final String USER_AGENT = "User-Agent";
    private static final Set<String> userAgents = new HashSet<String>();
    static final int SAMPLE_FREQ = 100;
    private int counter = 100;

    public ContainerRequest filter(ContainerRequest request) {
        if (this.counter++ < 100) {
            return request;
        }
        this.counter = 0;
        try {
            List headers = request.getRequestHeader(USER_AGENT);
            if (headers != null) {
                for (String header : headers) {
                    if (header == null) continue;
                    userAgents.add(header.replaceAll(" .*", ""));
                }
            }
        }
        catch (Exception e) {
            log.debug("Error retrieving User-Agent from " + request.getPath(), e);
        }
        return request;
    }

    public static Set<String> getUserAgents() {
        return userAgents;
    }

    public static void reset() {
        userAgents.clear();
    }
}

