/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webadmin.rest.console;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.servlet.http.HttpSession;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.server.database.CypherExecutor;
import org.neo4j.server.database.Database;
import org.neo4j.server.logging.Logger;
import org.neo4j.server.webadmin.console.ConsoleSessionCreator;
import org.neo4j.server.webadmin.console.ConsoleSessionFactory;
import org.neo4j.server.webadmin.console.ScriptSession;

public class SessionFactoryImpl
implements ConsoleSessionFactory {
    private static final Collection<ConsoleSessionCreator> creators = IteratorUtil.asCollection(ServiceLoader.load(ConsoleSessionCreator.class));
    private static final Logger log = Logger.getLogger(SessionFactoryImpl.class);
    private HttpSession httpSession;
    private final CypherExecutor cypherExecutor;
    private Map<String, ConsoleSessionCreator> engineCreators = new HashMap<String, ConsoleSessionCreator>();

    public SessionFactoryImpl(HttpSession httpSession, List<String> supportedEngines, CypherExecutor cypherExecutor) {
        this.httpSession = httpSession;
        this.cypherExecutor = cypherExecutor;
        this.enableEngines(supportedEngines);
    }

    @Override
    public ScriptSession createSession(String engineName, Database database) {
        if (this.engineCreators.containsKey(engineName = engineName.toLowerCase())) {
            return this.getOrInstantiateSession(database, engineName + "-console-session", this.engineCreators.get(engineName));
        }
        throw new IllegalArgumentException("Unknown console engine '" + engineName + "'.");
    }

    @Override
    public Iterable<String> supportedEngines() {
        return this.engineCreators.keySet();
    }

    private ScriptSession getOrInstantiateSession(Database database, String key, ConsoleSessionCreator creator) {
        Object session = this.httpSession.getAttribute(key);
        if (session == null) {
            session = creator.newSession(database, this.cypherExecutor);
            this.httpSession.setAttribute(key, session);
        }
        return (ScriptSession)session;
    }

    private void enableEngines(List<String> supportedEngines) {
        for (ConsoleSessionCreator creator : creators) {
            for (String engineName : supportedEngines) {
                if (!creator.name().equalsIgnoreCase(engineName)) continue;
                this.engineCreators.put(engineName.toLowerCase(), creator);
            }
        }
    }

    static {
        String info = "Available console sessions: ";
        for (ConsoleSessionCreator creator : creators) {
            info = info + creator.name() + ": " + creator.getClass() + "\n";
        }
        log.info(info, new Object[0]);
    }
}

