/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.statistic;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import org.mortbay.jetty.Response;
import org.neo4j.server.statistic.StatisticCollector;

public class StatisticFilter
implements Filter {
    private final StatisticCollector collector;

    public StatisticFilter(StatisticCollector collector) {
        this.collector = collector;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Long start = System.nanoTime();
        try {
            chain.doFilter(request, response);
        }
        finally {
            this.collector.update((double)(System.nanoTime() - start) / 1000000.0, this.getResponseSize(response));
        }
    }

    private long getResponseSize(ServletResponse response) {
        if (response instanceof ServletResponseWrapper) {
            ServletResponseWrapper wrapper = (ServletResponseWrapper)response;
            return this.getResponseSize(wrapper.getResponse());
        }
        if (response instanceof Response) {
            return ((Response)response).getContentCount();
        }
        return 0L;
    }

    public void destroy() {
    }
}

