/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.batch;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import org.codehaus.jackson.JsonGenerator;

public class StreamingBatchOperationResults {
    public static final int HEAD_BUFFER = 10;
    public static final int IS_ERROR = -1;
    private final String encoding = "UTF-8";
    private final Map<Integer, String> locations = new HashMap<Integer, String>();
    private final JsonGenerator g;
    private final ServletOutputStream output;
    private ByteArrayOutputStream errorStream;
    private int bytesWritten = 0;
    private char[] head = new char[10];

    public StreamingBatchOperationResults(JsonGenerator g, ServletOutputStream output) throws IOException {
        this.g = g;
        this.output = output;
        g.writeStartArray();
    }

    public void startOperation(String from, Integer id) throws IOException {
        this.bytesWritten = 0;
        this.g.writeStartObject();
        if (id != null) {
            this.g.writeNumberField("id", id.intValue());
        }
        this.g.writeStringField("from", from);
        this.g.writeRaw(",\"body\":");
        this.g.flush();
    }

    public void addOperationResult(int status, Integer id, String location) throws IOException {
        this.finishBody();
        if (location != null) {
            this.locations.put(id, location);
            this.g.writeStringField("location", location);
        }
        this.g.writeNumberField("status", status);
        this.g.writeEndObject();
    }

    private void finishBody() throws IOException {
        if (this.bytesWritten == 0) {
            this.g.writeRaw("null");
        } else if (this.bytesWritten < 10) {
            this.g.writeRaw(this.head, 0, this.bytesWritten);
        }
    }

    public ServletOutputStream getServletOutputStream() {
        return new ServletOutputStream(){

            public void write(int i) throws IOException {
                if (StreamingBatchOperationResults.this.redirectError(i)) {
                    return;
                }
                StreamingBatchOperationResults.this.writeChar(i);
                StreamingBatchOperationResults.this.bytesWritten++;
                StreamingBatchOperationResults.this.checkHead();
            }
        };
    }

    private boolean redirectError(int i) {
        if (this.bytesWritten != -1) {
            return false;
        }
        this.errorStream.write(i);
        return true;
    }

    private void writeChar(int i) throws IOException {
        if (this.bytesWritten < 10) {
            this.head[this.bytesWritten] = (char)i;
        } else {
            this.output.write(i);
        }
    }

    private void checkHead() throws IOException {
        if (this.bytesWritten == 10) {
            if (this.isJson(this.head)) {
                for (char c : this.head) {
                    this.output.write((int)c);
                }
            } else {
                this.errorStream = new ByteArrayOutputStream(1024);
                for (char c : this.head) {
                    this.errorStream.write(c);
                }
                this.bytesWritten = -1;
            }
        }
    }

    private boolean isJson(char[] head) {
        return String.valueOf(head).matches("\\s*([\\[\"\\{]|true|false).*");
    }

    public Map<Integer, String> getLocations() {
        return this.locations;
    }

    public void close() throws IOException {
        this.g.writeEndArray();
        this.g.close();
    }

    public void writeError(int status, String message) throws IOException {
        if (this.bytesWritten == 0 || this.bytesWritten == -1) {
            this.g.writeRaw("null");
        }
        this.g.writeNumberField("status", status);
        if (message != null && !message.trim().isEmpty()) {
            this.g.writeStringField("message", message);
        } else if (this.errorStream != null) {
            this.g.writeStringField("message", this.errorStream.toString("UTF-8"));
        }
        this.g.close();
    }
}

