/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.preflight;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.neo4j.kernel.impl.recovery.StoreRecoverer;
import org.neo4j.server.logging.Logger;
import org.neo4j.server.preflight.PreflightTask;

public class PerformRecoveryIfNecessary
implements PreflightTask {
    private final Logger logger = Logger.getLogger(PerformRecoveryIfNecessary.class);
    private String failureMessage = "Unable to recover database";
    private Configuration config;
    private PrintStream out;
    private Map<String, String> dbConfig;

    public PerformRecoveryIfNecessary(Configuration serverConfig, Map<String, String> dbConfig, PrintStream out) {
        this.config = serverConfig;
        this.dbConfig = dbConfig;
        this.out = out;
    }

    @Override
    public boolean run() {
        try {
            StoreRecoverer recoverer;
            File dbLocation = new File(this.config.getString("org.neo4j.server.database.location"));
            if (dbLocation.exists() && (recoverer = new StoreRecoverer()).recoveryNeededAt(dbLocation, this.dbConfig)) {
                this.out.println("Detected incorrectly shut down database, performing recovery..");
                recoverer.recover(dbLocation, this.dbConfig);
            }
            return true;
        }
        catch (IOException e) {
            this.logger.error("Recovery startup task failed.", e);
            return false;
        }
    }

    @Override
    public String getFailureMessage() {
        return this.failureMessage;
    }
}

