/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration.validation;

import java.util.ArrayList;
import org.apache.commons.configuration.Configuration;
import org.neo4j.server.configuration.validation.RuleFailedException;
import org.neo4j.server.configuration.validation.ValidationRule;
import org.neo4j.server.logging.Logger;

public class Validator {
    private static final Logger log = Logger.getLogger(Validator.class);
    private final ArrayList<ValidationRule> validationRules = new ArrayList();

    public Validator(ValidationRule ... rules) {
        if (rules == null) {
            return;
        }
        for (ValidationRule r : rules) {
            this.validationRules.add(r);
        }
    }

    public boolean validate(Configuration configuration) {
        for (ValidationRule vr : this.validationRules) {
            try {
                vr.validate(configuration);
            }
            catch (RuleFailedException rfe) {
                log.warn(rfe.getMessage(), new Object[0]);
                return false;
            }
        }
        return true;
    }
}

