/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import com.tinkerpop.pipes.util.structures.Row;
import com.tinkerpop.pipes.util.structures.Table;
import java.util.List;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.ObjectRepresentation;
import org.neo4j.server.rest.repr.ObjectToRepresentationConverter;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationType;

public class GremlinTableRepresentation
extends ObjectRepresentation {
    private final Table queryResult;
    private final ObjectToRepresentationConverter converter = new ObjectToRepresentationConverter();

    public GremlinTableRepresentation(Table result) {
        super(RepresentationType.STRING);
        this.queryResult = result;
    }

    @ObjectRepresentation.Mapping(value="columns")
    public Representation columns() {
        return ListRepresentation.string((Iterable)this.queryResult.getColumnNames());
    }

    @ObjectRepresentation.Mapping(value="data")
    public Representation data() {
        final List columnNames = this.queryResult.getColumnNames();
        IterableWrapper<Representation, Row> rows = new IterableWrapper<Representation, Row>((Iterable)this.queryResult){

            protected Representation underlyingObjectToObject(Row row) {
                return new ListRepresentation("row", GremlinTableRepresentation.this.convertRow(row, columnNames));
            }
        };
        return new ListRepresentation("data", (Iterable)rows);
    }

    private Iterable<Representation> convertRow(final Row row, List<String> columnNames) {
        return new IterableWrapper<Representation, String>(columnNames){

            protected Representation underlyingObjectToObject(String column) {
                Object fieldValue = row.getColumn(column);
                GremlinTableRepresentation.this.converter;
                return ObjectToRepresentationConverter.convert(fieldValue);
            }
        };
    }
}

