/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rrd;

import java.io.IOException;
import org.neo4j.server.rrd.RrdSampler;
import org.neo4j.server.rrd.Sampleable;
import org.neo4j.server.rrd.UnableToSampleException;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.Sample;
import org.rrd4j.core.Util;

public class RrdSamplerImpl
implements RrdSampler {
    private RrdDb rrdDb;
    private Sampleable[] samplables;

    protected RrdSamplerImpl(RrdDb rrdDb, Sampleable ... samplables) {
        this.rrdDb = rrdDb;
        this.samplables = samplables;
    }

    @Override
    public void updateSample() {
        try {
            Sample sample = this.rrdDb.createSample(Util.getTimestamp());
            for (Sampleable samplable : this.samplables) {
                sample.setValue(samplable.getName(), samplable.getValue());
            }
            sample.update();
        }
        catch (UnableToSampleException e) {
        }
        catch (IOException e) {
            throw new RuntimeException("IO Error trying to access round robin database path. See nested exception.", e);
        }
    }
}

