/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import com.tinkerpop.blueprints.pgm.impls.neo4j.Neo4jEdge;
import com.tinkerpop.blueprints.pgm.impls.neo4j.Neo4jGraph;
import com.tinkerpop.blueprints.pgm.impls.neo4j.Neo4jVertex;
import com.tinkerpop.pipes.util.structures.Table;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.collection.FirstItemIterable;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.helpers.collection.IteratorWrapper;
import org.neo4j.server.rest.repr.DatabaseRepresentation;
import org.neo4j.server.rest.repr.GremlinTableRepresentation;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.MapRepresentation;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.NodeRepresentation;
import org.neo4j.server.rest.repr.RelationshipRepresentation;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.ValueRepresentation;

public class ObjectToRepresentationConverter {
    public static Representation convert(Object data) {
        if (data instanceof Table) {
            return new GremlinTableRepresentation((Table)data);
        }
        if (data instanceof Iterable) {
            return ObjectToRepresentationConverter.getListRepresentation((Iterable)data);
        }
        if (data instanceof Iterator) {
            Iterator iterator = (Iterator)data;
            return ObjectToRepresentationConverter.getIteratorRepresentation(iterator);
        }
        if (data instanceof Map) {
            return ObjectToRepresentationConverter.getMapRepresentation((Map)data);
        }
        return ObjectToRepresentationConverter.getSingleRepresentation(data);
    }

    public static MappingRepresentation getMapRepresentation(Map data) {
        return new MapRepresentation(data);
    }

    static Representation getIteratorRepresentation(Iterator data) {
        FirstItemIterable results = new FirstItemIterable((Iterator)new IteratorWrapper<Representation, Object>(data){

            protected Representation underlyingObjectToObject(Object value) {
                if (value instanceof Iterable) {
                    FirstItemIterable<Representation> nested = ObjectToRepresentationConverter.convertValuesToRepresentations((Iterable)value);
                    return new ListRepresentation(ObjectToRepresentationConverter.getType(nested), nested);
                }
                return ObjectToRepresentationConverter.getSingleRepresentation(value);
            }
        });
        return new ListRepresentation(ObjectToRepresentationConverter.getType((FirstItemIterable<Representation>)results), (Iterable)results);
    }

    public static ListRepresentation getListRepresentation(Iterable data) {
        FirstItemIterable<Representation> results = ObjectToRepresentationConverter.convertValuesToRepresentations(data);
        return new ListRepresentation(ObjectToRepresentationConverter.getType(results), results);
    }

    static FirstItemIterable<Representation> convertValuesToRepresentations(Iterable data) {
        if (data instanceof Table) {
            return new FirstItemIterable(Collections.singleton(new GremlinTableRepresentation((Table)data)));
        }
        return new FirstItemIterable((Iterable)new IterableWrapper<Representation, Object>(data){

            protected Representation underlyingObjectToObject(Object value) {
                if (value instanceof Iterable) {
                    FirstItemIterable<Representation> nested = ObjectToRepresentationConverter.convertValuesToRepresentations((Iterable)value);
                    return new ListRepresentation(ObjectToRepresentationConverter.getType(nested), nested);
                }
                return ObjectToRepresentationConverter.getSingleRepresentation(value);
            }
        });
    }

    static RepresentationType getType(FirstItemIterable<Representation> representations) {
        Representation representation = (Representation)representations.getFirst();
        if (representation == null) {
            return RepresentationType.STRING;
        }
        return representation.getRepresentationType();
    }

    static Representation getSingleRepresentation(Object result) {
        if (result == null) {
            return ValueRepresentation.string((String)"null");
        }
        if (result instanceof Neo4jVertex) {
            return new NodeRepresentation(((Neo4jVertex)result).getRawVertex());
        }
        if (result instanceof Neo4jEdge) {
            return new RelationshipRepresentation(((Neo4jEdge)result).getRawEdge());
        }
        if (result instanceof GraphDatabaseService) {
            return new DatabaseRepresentation((GraphDatabaseService)result);
        }
        if (result instanceof Node) {
            return new NodeRepresentation((Node)result);
        }
        if (result instanceof Relationship) {
            return new RelationshipRepresentation((Relationship)result);
        }
        if (result instanceof Neo4jGraph) {
            return ValueRepresentation.string((String)((Neo4jGraph)result).getRawGraph().toString());
        }
        if (result instanceof Double || result instanceof Float) {
            return ValueRepresentation.number((double)((Number)result).doubleValue());
        }
        if (result instanceof Long) {
            return ValueRepresentation.number((long)((Long)result));
        }
        if (result instanceof Integer) {
            return ValueRepresentation.number((int)((Integer)result));
        }
        return ValueRepresentation.string((String)result.toString());
    }
}

