/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.NodeRepresentation;
import org.neo4j.server.rest.repr.PathRepresentation;
import org.neo4j.server.rest.repr.RelationshipRepresentation;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationExceptionHandlingIterable;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.ValueRepresentation;
import org.neo4j.server.webadmin.rest.representations.JmxAttributeRepresentationDispatcher;

public class CypherResultRepresentation
extends MappingRepresentation {
    private final ListRepresentation resultRepresentation;
    private final ListRepresentation columns;

    public CypherResultRepresentation(ExecutionResult result) {
        super(RepresentationType.STRING);
        this.resultRepresentation = this.createResultRepresentation(result);
        this.columns = ListRepresentation.string((Iterable)result.columns());
    }

    protected void serialize(MappingSerializer serializer) {
        serializer.putList("columns", this.columns);
        serializer.putList("data", this.resultRepresentation);
    }

    private ListRepresentation createResultRepresentation(ExecutionResult executionResult) {
        final List columns = executionResult.columns();
        RepresentationExceptionHandlingIterable inner = new RepresentationExceptionHandlingIterable(executionResult);
        return new ListRepresentation("data", (Iterable)new IterableWrapper<Representation, Map<String, Object>>(inner){

            protected Representation underlyingObjectToObject(final Map<String, Object> row) {
                return new ListRepresentation("row", (Iterable)new IterableWrapper<Representation, String>((Iterable)columns){

                    protected Representation underlyingObjectToObject(String column) {
                        return CypherResultRepresentation.this.getRepresentation(row.get(column));
                    }
                });
            }
        });
    }

    Representation getRepresentation(Object r) {
        if (r == null) {
            return ValueRepresentation.string(null);
        }
        if (r instanceof Path) {
            return new PathRepresentation<Path>((Path)r);
        }
        if (r instanceof Iterable) {
            return this.handleIterable((Iterable)r);
        }
        if (r instanceof Node) {
            return new NodeRepresentation((Node)r);
        }
        if (r instanceof Relationship) {
            return new RelationshipRepresentation((Relationship)r);
        }
        JmxAttributeRepresentationDispatcher representationDispatcher = new JmxAttributeRepresentationDispatcher();
        return (Representation)representationDispatcher.dispatch(r, "");
    }

    Representation handleIterable(Iterable data) {
        ArrayList<Representation> results = new ArrayList<Representation>();
        for (Object value : data) {
            Representation rep = this.getRepresentation(value);
            results.add(rep);
        }
        RepresentationType representationType = this.getType(results);
        return new ListRepresentation(representationType, results);
    }

    RepresentationType getType(List<Representation> representations) {
        if (representations == null || representations.isEmpty()) {
            return RepresentationType.STRING;
        }
        return representations.get(0).getRepresentationType();
    }
}

