/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class SimpleConsoleFormatter
extends Formatter {
    private Date date = new Date();
    private static final String timestampFormat = "{0,date,short} {0,time}";
    private final MessageFormat formatter = new MessageFormat("{0,date,short} {0,time}");
    private final Object[] args = new Object[]{this.date};
    private static final String lineSeparator = System.getProperty("line.separator");

    @Override
    public synchronized String format(LogRecord record) {
        StringBuffer sb = new StringBuffer();
        this.date.setTime(record.getMillis());
        StringBuffer text = new StringBuffer();
        this.formatter.format(this.args, text, (FieldPosition)null);
        sb.append(text);
        sb.append(" ");
        sb.append(record.getLoggerName());
        sb.append(" ");
        String message = this.formatMessage(record);
        sb.append(record.getLevel().getLocalizedName());
        sb.append(": ");
        sb.append(message);
        sb.append(lineSeparator);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return sb.toString();
    }
}

