/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.info.DiagnosticsManager;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.server.NeoServer;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.database.CypherExecutor;
import org.neo4j.server.database.Database;
import org.neo4j.server.logging.Logger;
import org.neo4j.server.modules.PluginInitializer;
import org.neo4j.server.modules.RESTApiModule;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.plugins.Injectable;
import org.neo4j.server.plugins.PluginManager;
import org.neo4j.server.security.KeyStoreFactory;
import org.neo4j.server.security.KeyStoreInformation;
import org.neo4j.server.security.SslCertificateFactory;
import org.neo4j.server.startup.healthcheck.StartupHealthCheck;
import org.neo4j.server.startup.healthcheck.StartupHealthCheckFailedException;
import org.neo4j.server.statistic.StatisticCollector;
import org.neo4j.server.web.SimpleUriBuilder;
import org.neo4j.server.web.WebServer;

public abstract class AbstractNeoServer
implements NeoServer {
    public static final Logger log = Logger.getLogger(AbstractNeoServer.class);
    protected Database database;
    protected Configurator configurator;
    protected WebServer webServer;
    protected final StatisticCollector statisticsCollector = new StatisticCollector();
    private StartupHealthCheck startupHealthCheck;
    private PluginInitializer pluginInitializer;
    private final List<ServerModule> serverModules = new ArrayList<ServerModule>();
    private final SimpleUriBuilder uriBuilder = new SimpleUriBuilder();
    private CypherExecutor cypherExecutor;

    protected abstract StartupHealthCheck createHealthCheck();

    protected abstract Iterable<ServerModule> createServerModules();

    protected abstract Database createDatabase();

    protected abstract WebServer createWebServer();

    @Override
    public void init() {
        this.startupHealthCheck = this.createHealthCheck();
        this.database = this.createDatabase();
        this.webServer = this.createWebServer();
        this.pluginInitializer = new PluginInitializer(this);
        this.webServer.setNeoServer(this);
        for (ServerModule moduleClass : this.createServerModules()) {
            this.registerModule(moduleClass);
        }
    }

    protected Logging getLogging() {
        GraphDatabaseAPI graph = this.database.getGraph();
        if (graph instanceof InternalAbstractGraphDatabase) {
            InternalAbstractGraphDatabase internalAbstractGraphDatabase = (InternalAbstractGraphDatabase)graph;
            return internalAbstractGraphDatabase.getLogging();
        }
        return new Logging(){

            public StringLogger getLogger(String name) {
                return StringLogger.DEV_NULL;
            }
        };
    }

    @Override
    public void start() {
        try {
            this.startupHealthCheck();
            this.database.start();
            this.cypherExecutor = new CypherExecutor(this.database, this.getLogging().getLogger("neo4j.cypher"));
            this.configureWebServer();
            this.cypherExecutor.start();
            DiagnosticsManager diagnosticsManager = this.database.getGraph().getDiagnosticsManager();
            StringLogger logger = diagnosticsManager.getTargetLog();
            logger.logMessage("--- SERVER STARTUP START ---");
            diagnosticsManager.register(Configurator.DIAGNOSTICS, (Object)this.configurator);
            this.startModules(logger);
            this.startWebServer(logger);
            logger.logMessage("--- SERVER STARTUP END ---", true);
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException("Starting neo server failed, see nested exception.", t);
        }
    }

    protected final void registerModule(ServerModule module) {
        this.serverModules.add(module);
    }

    private void startModules(StringLogger logger) {
        for (ServerModule module : this.serverModules) {
            module.start(logger);
        }
    }

    private void stopModules() {
        for (ServerModule module : this.serverModules) {
            try {
                module.stop();
            }
            catch (Exception e) {
                log.error(e);
            }
        }
    }

    private void startupHealthCheck() {
        if (!this.startupHealthCheck.run()) {
            throw new StartupHealthCheckFailedException(this.startupHealthCheck.failedRule());
        }
    }

    @Override
    public Configuration getConfiguration() {
        return this.configurator.configuration();
    }

    private void configureWebServer() {
        int webServerPort = this.getWebServerPort();
        String webServerAddr = this.getWebServerAddress();
        int maxThreads = this.getMaxThreads();
        int sslPort = this.getHttpsPort();
        boolean sslEnabled = this.getHttpsEnabled();
        log.info("Starting Neo Server on port [%s] with [%d] threads available", webServerPort, maxThreads);
        this.webServer.setPort(webServerPort);
        this.webServer.setAddress(webServerAddr);
        this.webServer.setMaxThreads(maxThreads);
        this.webServer.setEnableHttps(sslEnabled);
        this.webServer.setHttpsPort(sslPort);
        if (sslEnabled) {
            log.info("Enabling HTTPS on port [%s]", sslPort);
            this.webServer.setHttpsCertificateInformation(this.initHttpsKeyStore());
        }
    }

    private int getMaxThreads() {
        return this.configurator.configuration().containsKey("org.neo4j.server.webserver.maxthreads") ? this.configurator.configuration().getInt("org.neo4j.server.webserver.maxthreads") : this.defaultMaxWebServerThreads();
    }

    private int defaultMaxWebServerThreads() {
        return 10 * Runtime.getRuntime().availableProcessors();
    }

    private void startWebServer(StringLogger logger) {
        try {
            if (this.httpLoggingProperlyConfigured()) {
                this.webServer.setHttpLoggingConfiguration(new File(this.getConfiguration().getProperty("org.neo4j.server.http.log.config").toString()));
            }
            this.webServer.start();
            if (logger != null) {
                logger.logMessage("Server started on: " + this.baseUri());
            }
            log.info("Server started on [%s]", this.baseUri());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Failed to start Neo Server on port [%d], reason [%s]", this.getWebServerPort(), e.getMessage());
        }
    }

    private boolean httpLoggingProperlyConfigured() {
        return this.loggingEnabled() && this.configLocated();
    }

    private boolean configLocated() {
        Object property = this.getConfiguration().getProperty("org.neo4j.server.http.log.config");
        if (property == null) {
            return false;
        }
        return new File(String.valueOf(property)).exists();
    }

    private boolean loggingEnabled() {
        return "true".equals(String.valueOf(this.getConfiguration().getProperty("org.neo4j.server.http.log.enabled")));
    }

    protected int getWebServerPort() {
        return this.configurator.configuration().getInt("org.neo4j.server.webserver.port", 7474);
    }

    protected boolean getHttpsEnabled() {
        return this.configurator.configuration().getBoolean("org.neo4j.server.webserver.https.enabled", Configurator.DEFAULT_WEBSERVER_HTTPS_ENABLED);
    }

    protected int getHttpsPort() {
        return this.configurator.configuration().getInt("org.neo4j.server.webserver.https.port", 7473);
    }

    protected String getWebServerAddress() {
        return this.configurator.configuration().getString("org.neo4j.server.webserver.address", "localhost");
    }

    protected KeyStoreInformation initHttpsKeyStore() {
        File keystorePath = new File(this.configurator.configuration().getString("org.neo4j.server.webserver.https.keystore.location", "neo4j-home/ssl/keystore"));
        File privateKeyPath = new File(this.configurator.configuration().getString("org.neo4j.server.webserver.https.key.location", "neo4j-home/ssl/snakeoil.key"));
        File certificatePath = new File(this.configurator.configuration().getString("org.neo4j.server.webserver.https.cert.location", "neo4j-home/ssl/snakeoil.cert"));
        if (!certificatePath.exists()) {
            log.info("No SSL certificate found, generating a self-signed certificate..", new Object[0]);
            SslCertificateFactory certFactory = new SslCertificateFactory();
            certFactory.createSelfSignedCertificate(certificatePath, privateKeyPath, this.getWebServerAddress());
        }
        KeyStoreFactory keyStoreFactory = new KeyStoreFactory();
        return keyStoreFactory.createKeyStore(keystorePath, privateKeyPath, certificatePath);
    }

    @Override
    public void stop() {
        try {
            this.stopServerOnly();
            this.stopDatabase();
            log.info("Successfully shutdown database.", new Object[0]);
        }
        catch (Exception e) {
            log.warn("Failed to cleanly shutdown database.", new Object[0]);
        }
    }

    @Deprecated
    public void stopServerOnly() {
        try {
            this.stopWebServer();
            this.stopModules();
            this.stopExtensionInitializers();
            log.info("Successfully shutdown Neo4j Server.", new Object[0]);
        }
        catch (Exception e) {
            log.warn("Failed to cleanly shutdown Neo4j Server.", new Object[0]);
        }
    }

    private void stopExtensionInitializers() {
        this.pluginInitializer.stop();
    }

    private void stopWebServer() {
        if (this.webServer != null) {
            this.webServer.stop();
        }
    }

    private void stopDatabase() {
        if (this.database != null) {
            try {
                this.database.stop();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    @Override
    public CypherExecutor getCypherExecutor() {
        return this.cypherExecutor;
    }

    @Override
    public URI baseUri() {
        return this.uriBuilder.buildURI(this.getWebServerAddress(), this.getWebServerPort(), false);
    }

    public URI httpsUri() {
        return this.uriBuilder.buildURI(this.getWebServerAddress(), this.getHttpsPort(), true);
    }

    public WebServer getWebServer() {
        return this.webServer;
    }

    @Override
    public Configurator getConfigurator() {
        return this.configurator;
    }

    @Override
    public PluginManager getExtensionManager() {
        if (this.hasModule(RESTApiModule.class)) {
            return this.getModule(RESTApiModule.class).getPlugins();
        }
        return null;
    }

    @Override
    public Collection<Injectable<?>> getInjectables(List<String> packageNames) {
        return this.pluginInitializer.initializePackages(packageNames);
    }

    private boolean hasModule(Class<? extends ServerModule> clazz) {
        for (ServerModule sm : this.serverModules) {
            if (sm.getClass() != clazz) continue;
            return true;
        }
        return false;
    }

    private <T extends ServerModule> T getModule(Class<T> clazz) {
        for (ServerModule sm : this.serverModules) {
            if (sm.getClass() != clazz) continue;
            return (T)sm;
        }
        return null;
    }
}

