/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.annotations.service;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.impl.factory.Multimaps;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.neo4j.annotations.service.Service;
import org.neo4j.annotations.service.ServiceProvider;

public class ServiceAnnotationProcessor
extends AbstractProcessor {
    private static final boolean ENABLE_DEBUG = Boolean.getBoolean("enableAnnotationLogging");
    private final MutableMultimap<TypeElement, TypeElement> serviceProviders;
    private final String newLine;
    private Types typeUtils;
    private Elements elementUtils;

    public ServiceAnnotationProcessor() {
        this("\n");
    }

    public ServiceAnnotationProcessor(String newLine) {
        this.serviceProviders = Multimaps.mutable.list.empty();
        this.newLine = newLine;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.typeUtils = processingEnv.getTypeUtils();
        this.elementUtils = processingEnv.getElementUtils();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return UnifiedSet.newSetWith((Object[])new String[]{ServiceProvider.class.getName()});
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            if (roundEnv.processingOver()) {
                if (!roundEnv.errorRaised()) {
                    this.generateConfigs();
                }
            } else {
                this.scan(roundEnv);
            }
        }
        catch (Exception e) {
            this.error("Service annotation processor failed", e);
        }
        return false;
    }

    private void scan(RoundEnvironment roundEnv) {
        Set elements = roundEnv.getElementsAnnotatedWith(ServiceProvider.class).stream().map(TypeElement.class::cast).collect(Collectors.toSet());
        this.info("Processing service providers: " + elements.stream().map(Object::toString).sorted().collect(Collectors.toList()));
        for (TypeElement serviceProvider : elements) {
            this.getImplementedService(serviceProvider).ifPresent(service -> {
                this.info(String.format("Service %s provided by %s", service, serviceProvider));
                this.serviceProviders.put(service, (Object)serviceProvider);
            });
        }
    }

    private Optional<TypeElement> getImplementedService(TypeElement serviceProvider) {
        Set<TypeMirror> types = this.getTypeWithSupertypes(serviceProvider.asType());
        List services = types.stream().filter(this::isService).collect(Collectors.toList());
        if (services.isEmpty()) {
            this.error(String.format("Service provider %s neither has ascendants nor itself annotated with @Service)", serviceProvider), serviceProvider);
            return Optional.empty();
        }
        if (services.size() > 1) {
            this.error(String.format("Service provider %s has multiple ascendants annotated with @Service: %s", serviceProvider, services), serviceProvider);
            return Optional.empty();
        }
        return Optional.of((TypeElement)this.typeUtils.asElement((TypeMirror)services.get(0)));
    }

    private boolean isService(TypeMirror type) {
        return this.typeUtils.asElement(type).getAnnotation(Service.class) != null;
    }

    private Set<TypeMirror> getTypeWithSupertypes(TypeMirror type) {
        HashSet<TypeMirror> allTypes = new HashSet<TypeMirror>();
        allTypes.add(type);
        List<? extends TypeMirror> directSupertypes = this.typeUtils.directSupertypes(type);
        directSupertypes.forEach(directSupertype -> allTypes.addAll(this.getTypeWithSupertypes((TypeMirror)directSupertype)));
        return allTypes;
    }

    private void generateConfigs() throws IOException {
        for (TypeElement service : this.serviceProviders.keySet()) {
            String path = "META-INF/services/" + this.elementUtils.getBinaryName(service);
            this.info("Generating service config file: " + path);
            SortedSet<String> oldProviders = this.loadIfExists(path);
            TreeSet<String> newProviders = new TreeSet<String>();
            this.serviceProviders.get((Object)service).forEach((Procedure & Serializable)providerType -> {
                String providerName = this.elementUtils.getBinaryName((TypeElement)providerType).toString();
                newProviders.add(providerName);
            });
            if (oldProviders.containsAll(newProviders)) {
                this.info("No new service providers found");
                return;
            }
            newProviders.addAll(oldProviders);
            FileObject file = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", path, new Element[0]);
            try (BufferedWriter writer = new BufferedWriter(file.openWriter());){
                this.info("Writing service providers: " + newProviders);
                for (String provider : newProviders) {
                    writer.write(provider);
                    writer.write(this.newLine);
                }
            }
        }
    }

    private SortedSet<String> loadIfExists(String path) {
        TreeSet<String> result = new TreeSet<String>();
        try {
            FileObject file = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", path);
            ArrayList<String> lines = new ArrayList<String>();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(file.openInputStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = in.readLine()) != null) {
                    lines.add(line);
                }
            }
            lines.stream().map(s -> StringUtils.substringBefore((String)s, (String)"#")).map(String::trim).filter(StringUtils::isNotEmpty).forEach(result::add);
            this.info("Loaded existing providers: " + result);
        }
        catch (IOException ignore) {
            this.info("No existing providers loaded");
        }
        return result;
    }

    private void info(String msg) {
        if (ENABLE_DEBUG) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, msg);
        }
    }

    private void error(String msg, Exception e) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg + ": " + ExceptionUtils.getStackTrace((Throwable)e));
    }

    private void error(String msg, Element element) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, element);
    }
}

