/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu.nativecpu;

import java.util.Map;
import lombok.NonNull;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.memory.AllocationsTracker;
import org.nd4j.linalg.api.memory.enums.AllocationKind;
import org.nd4j.linalg.api.memory.enums.MemoryKind;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.memory.BasicMemoryManager;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpuMemoryManager
extends BasicMemoryManager {
    private static final Logger log = LoggerFactory.getLogger(CpuMemoryManager.class);

    public Pointer allocate(long bytes, MemoryKind kind, boolean initialize) {
        Pointer ptr = NativeOpsHolder.getInstance().getDeviceNativeOps().mallocHost(bytes, 0);
        if (ptr == null || ptr.address() == 0L) {
            throw new OutOfMemoryError("Failed to allocate [" + bytes + "] bytes");
        }
        if (initialize) {
            Pointer.memset((Pointer)ptr, (int)0, (long)bytes);
        }
        return ptr;
    }

    public void release(@NonNull Pointer pointer, MemoryKind kind) {
        if (pointer == null) {
            throw new NullPointerException("pointer is marked @NonNull but is null");
        }
        Pointer.free((Pointer)pointer);
        pointer.setNull();
    }

    public void collect(INDArray ... arrays) {
        super.collect(arrays);
    }

    public boolean isPeriodicGcActive() {
        return false;
    }

    public void memset(INDArray array) {
        if (array.isView()) {
            array.assign((Number)0.0);
            return;
        }
        Pointer.memset((Pointer)array.data().addressPointer(), (int)0, (long)(array.data().length() * (long)Nd4j.sizeOfDataType((DataType)array.data().dataType())));
    }

    public Map<Integer, Long> getBandwidthUse() {
        return null;
    }

    public long allocatedMemory(Integer deviceId) {
        return Pointer.totalBytes() + AllocationsTracker.getInstance().bytesOnDevice(AllocationKind.GENERAL, deviceId) + AllocationsTracker.getInstance().bytesOnDevice(AllocationKind.WORKSPACE, deviceId);
    }
}

