/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu.nativecpu;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.BaseShapeInfoProvider;
import org.nd4j.linalg.api.shape.ShapeDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectShapeInfoProvider
extends BaseShapeInfoProvider {
    private static final Logger log = LoggerFactory.getLogger(DirectShapeInfoProvider.class);
    private Map<ShapeDescriptor, DataBuffer> shapeCache = new ConcurrentHashMap<ShapeDescriptor, DataBuffer>();
    private AtomicInteger counter = new AtomicInteger(0);
    private static final int MAX_ENTRIES = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBuffer createShapeInformation(int[] shape, int[] stride, int offset, int elementWiseStride, char order) {
        offset = 0;
        ShapeDescriptor descriptor = new ShapeDescriptor(shape, stride, offset, elementWiseStride, order);
        if (!this.shapeCache.containsKey(descriptor)) {
            if (this.counter.get() < 100) {
                DirectShapeInfoProvider directShapeInfoProvider = this;
                synchronized (directShapeInfoProvider) {
                    if (!this.shapeCache.containsKey(descriptor)) {
                        this.counter.incrementAndGet();
                        DataBuffer buffer = super.createShapeInformation(shape, stride, offset, elementWiseStride, order);
                        this.shapeCache.put(descriptor, buffer);
                        return buffer;
                    }
                    return this.shapeCache.get(descriptor);
                }
            }
            return super.createShapeInformation(shape, stride, offset, elementWiseStride, order);
        }
        return this.shapeCache.get(descriptor);
    }

    public void purgeCache() {
        this.shapeCache = new ConcurrentHashMap<ShapeDescriptor, DataBuffer>();
    }
}

