/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.common.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import org.nd4j.common.io.AbstractResource;
import org.nd4j.common.io.Resource;
import org.nd4j.common.io.ResourceUtils;
import org.nd4j.common.io.VfsResource;
import org.nd4j.common.io.VfsUtils;

public abstract class AbstractFileResolvingResource
extends AbstractResource {
    @Override
    public File getFile() throws IOException {
        URL url = this.getURL();
        return url.getProtocol().startsWith("vfs") ? VfsResourceDelegate.getResource(url).getFile() : ResourceUtils.getFile(url, this.getDescription());
    }

    @Override
    protected File getFileForLastModifiedCheck() throws IOException {
        URL url = this.getURL();
        if (ResourceUtils.isJarURL(url)) {
            URL actualUrl = ResourceUtils.extractJarFileURL(url);
            return actualUrl.getProtocol().startsWith("vfs") ? VfsResourceDelegate.getResource(actualUrl).getFile() : ResourceUtils.getFile(actualUrl, "Jar URL");
        }
        return this.getFile();
    }

    protected File getFile(URI uri) throws IOException {
        return uri.getScheme().startsWith("vfs") ? VfsResourceDelegate.getResource(uri).getFile() : ResourceUtils.getFile(uri, this.getDescription());
    }

    @Override
    public boolean exists() {
        try {
            HttpURLConnection httpCon;
            URL ex = this.getURL();
            if (ResourceUtils.isFileURL(ex)) {
                return this.getFile().exists();
            }
            URLConnection con = ex.openConnection();
            ResourceUtils.useCachesIfNecessary(con);
            HttpURLConnection httpURLConnection = httpCon = con instanceof HttpURLConnection ? (HttpURLConnection)con : null;
            if (httpCon != null) {
                httpCon.setRequestMethod("HEAD");
                int is = httpCon.getResponseCode();
                if (is == 200) {
                    return true;
                }
                if (is == 404) {
                    return false;
                }
            }
            if (con.getContentLength() >= 0) {
                return true;
            }
            if (httpCon != null) {
                httpCon.disconnect();
                return false;
            }
            InputStream is1 = this.getInputStream();
            is1.close();
            return true;
        }
        catch (IOException var5) {
            return false;
        }
    }

    @Override
    public boolean isReadable() {
        try {
            URL ex = this.getURL();
            if (!ResourceUtils.isFileURL(ex)) {
                return true;
            }
            File file = this.getFile();
            return file.canRead() && !file.isDirectory();
        }
        catch (IOException var3) {
            return false;
        }
    }

    @Override
    public long contentLength() throws IOException {
        URL url = this.getURL();
        if (ResourceUtils.isFileURL(url)) {
            return this.getFile().length();
        }
        URLConnection con = url.openConnection();
        ResourceUtils.useCachesIfNecessary(con);
        if (con instanceof HttpURLConnection) {
            ((HttpURLConnection)con).setRequestMethod("HEAD");
        }
        return con.getContentLength();
    }

    @Override
    public long lastModified() throws IOException {
        URL url = this.getURL();
        if (!ResourceUtils.isFileURL(url) && !ResourceUtils.isJarURL(url)) {
            URLConnection con = url.openConnection();
            ResourceUtils.useCachesIfNecessary(con);
            if (con instanceof HttpURLConnection) {
                ((HttpURLConnection)con).setRequestMethod("HEAD");
            }
            return con.getLastModified();
        }
        return super.lastModified();
    }

    private static class VfsResourceDelegate {
        private VfsResourceDelegate() {
        }

        public static Resource getResource(URL url) throws IOException {
            return new VfsResource(VfsUtils.getRoot(url));
        }

        public static Resource getResource(URI uri) throws IOException {
            return new VfsResource(VfsUtils.getRoot(uri));
        }
    }
}

