/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.primitives;

import java.beans.ConstructorProperties;
import java.io.Serializable;

public class Triple<F, S, T>
implements Serializable {
    private static final long serialVersionUID = 119L;
    protected F first;
    protected S second;
    protected T third;

    public F getLeft() {
        return this.first;
    }

    public S getMiddle() {
        return this.second;
    }

    public T getRight() {
        return this.third;
    }

    public static <F, S, T> Triple<F, S, T> tripleOf(F first, S second, T third) {
        return new Triple<F, S, T>(first, second, third);
    }

    public static <F, S, T> Triple<F, S, T> of(F first, S second, T third) {
        return new Triple<F, S, T>(first, second, third);
    }

    public static <F, S, T> TripleBuilder<F, S, T> builder() {
        return new TripleBuilder();
    }

    public F getFirst() {
        return this.first;
    }

    public S getSecond() {
        return this.second;
    }

    public T getThird() {
        return this.third;
    }

    public void setFirst(F first) {
        this.first = first;
    }

    public void setSecond(S second) {
        this.second = second;
    }

    public void setThird(T third) {
        this.third = third;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Triple)) {
            return false;
        }
        Triple other = (Triple)o;
        if (!other.canEqual(this)) {
            return false;
        }
        F this$first = this.getFirst();
        F other$first = other.getFirst();
        if (this$first == null ? other$first != null : !this$first.equals(other$first)) {
            return false;
        }
        S this$second = this.getSecond();
        S other$second = other.getSecond();
        if (this$second == null ? other$second != null : !this$second.equals(other$second)) {
            return false;
        }
        T this$third = this.getThird();
        T other$third = other.getThird();
        return !(this$third == null ? other$third != null : !this$third.equals(other$third));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Triple;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        F $first = this.getFirst();
        result = result * 59 + ($first == null ? 43 : $first.hashCode());
        S $second = this.getSecond();
        result = result * 59 + ($second == null ? 43 : $second.hashCode());
        T $third = this.getThird();
        result = result * 59 + ($third == null ? 43 : $third.hashCode());
        return result;
    }

    public String toString() {
        return "Triple(first=" + this.getFirst() + ", second=" + this.getSecond() + ", third=" + this.getThird() + ")";
    }

    public Triple() {
    }

    @ConstructorProperties(value={"first", "second", "third"})
    public Triple(F first, S second, T third) {
        this.first = first;
        this.second = second;
        this.third = third;
    }

    public static class TripleBuilder<F, S, T> {
        private F first;
        private S second;
        private T third;

        TripleBuilder() {
        }

        public TripleBuilder<F, S, T> first(F first) {
            this.first = first;
            return this;
        }

        public TripleBuilder<F, S, T> second(S second) {
            this.second = second;
            return this;
        }

        public TripleBuilder<F, S, T> third(T third) {
            this.third = third;
            return this;
        }

        public Triple<F, S, T> build() {
            return new Triple<F, S, T>(this.first, this.second, this.third);
        }

        public String toString() {
            return "Triple.TripleBuilder(first=" + this.first + ", second=" + this.second + ", third=" + this.third + ")";
        }
    }
}

