/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.buffer;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Collection;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.Indexer;
import org.nd4j.linalg.api.complex.IComplexDouble;
import org.nd4j.linalg.api.complex.IComplexFloat;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.memory.MemoryWorkspace;

public interface DataBuffer
extends Serializable {
    public Pointer pointer();

    public Pointer addressPointer();

    public Indexer indexer();

    public long address();

    public boolean sameUnderlyingData(DataBuffer var1);

    public void read(DataInputStream var1);

    public void write(DataOutputStream var1) throws IOException;

    public Object array();

    public IntBuffer asNioInt();

    public DoubleBuffer asNioDouble();

    public FloatBuffer asNioFloat();

    public ByteBuffer asNio();

    public boolean dirty();

    public DataBuffer underlyingDataBuffer();

    public DataBuffer originalDataBuffer();

    public void copyAtStride(DataBuffer var1, long var2, long var4, long var6, long var8, long var10);

    public AllocationMode allocationMode();

    public void persist();

    public boolean isPersist();

    public void unPersist();

    public int getElementSize();

    public void removeReferencing(String var1);

    public Collection<String> references();

    public void addReferencing(String var1);

    public void assign(long[] var1, float[] var2, boolean var3, long var4);

    public void assign(long[] var1, double[] var2, boolean var3, long var4);

    public void assign(long[] var1, float[] var2, boolean var3);

    public void assign(long[] var1, double[] var2, boolean var3);

    public double[] getDoublesAt(long var1, int var3);

    public float[] getFloatsAt(long var1, int var3);

    public double[] getDoublesAt(long var1, long var3, int var5);

    public float[] getFloatsAt(long var1, long var3, int var5);

    public void assign(Number var1);

    public void assign(Number var1, long var2);

    public void setData(int[] var1);

    public void setData(float[] var1);

    public void setData(double[] var1);

    public byte[] asBytes();

    public Type dataType();

    public float[] asFloat();

    public double[] asDouble();

    public int[] asInt();

    public double getDouble(long var1);

    public long getLong(long var1);

    public float getFloat(long var1);

    public Number getNumber(long var1);

    public void put(long var1, float var3);

    public void put(long var1, double var3);

    public void put(long var1, int var3);

    public IComplexFloat getComplexFloat(long var1);

    public IComplexDouble getComplexDouble(long var1);

    public IComplexNumber getComplex(long var1);

    public long length();

    public long underlyingLength();

    public long offset();

    public long originalOffset();

    public int getInt(long var1);

    public DataBuffer dup();

    public void flush();

    public void put(long var1, IComplexNumber var3);

    public void assign(DataBuffer var1);

    public void assign(long[] var1, long[] var2, long var3, DataBuffer ... var5);

    public void assign(DataBuffer ... var1);

    public void assign(long[] var1, long[] var2, DataBuffer ... var3);

    public void destroy();

    public void write(OutputStream var1);

    public void read(InputStream var1);

    public Long getTrackingPoint();

    public void setTrackingPoint(Long var1);

    public boolean isConstant();

    public void setConstant(boolean var1);

    public boolean isAttached();

    public boolean isInScope();

    public MemoryWorkspace getParentWorkspace();

    public DataBuffer reallocate(long var1);

    public long capacity();

    public static enum AllocationMode {
        DIRECT,
        HEAP,
        JAVACPP;

    }

    public static enum TypeEx {
        FLOAT8,
        INT8,
        UINT8,
        FLOAT16,
        INT16,
        UINT16,
        FLOAT,
        DOUBLE,
        THRESHOLD,
        FTHRESHOLD;

    }

    public static enum Type {
        DOUBLE,
        FLOAT,
        INT,
        HALF,
        COMPRESSED,
        LONG;

    }
}

