/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.weightinit.impl;

import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.weightinit.BaseWeightInitScheme;
import org.nd4j.weightinit.WeightInit;

public class VarScalingUniformFanAvgInitScheme
extends BaseWeightInitScheme {
    private double fanIn;
    private double fanOut;

    public VarScalingUniformFanAvgInitScheme(char order, double fanIn, double fanOut) {
        super(order);
        this.fanIn = fanIn;
        this.fanOut = fanOut;
    }

    @Override
    public INDArray doCreate(DataType dataType, long[] shape, INDArray paramsView) {
        double scalingFanAvg = 3.0 / Math.sqrt((this.fanIn + this.fanOut) / 2.0);
        return Nd4j.rand(Nd4j.getDistributions().createUniform(-scalingFanAvg, scalingFanAvg), shape);
    }

    @Override
    public WeightInit type() {
        return WeightInit.VAR_SCALING_UNIFORM_FAN_AVG;
    }

    public static VarScalingUniformFanAvgInitSchemeBuilder builder() {
        return new VarScalingUniformFanAvgInitSchemeBuilder();
    }

    public static class VarScalingUniformFanAvgInitSchemeBuilder {
        private char order;
        private double fanIn;
        private double fanOut;

        VarScalingUniformFanAvgInitSchemeBuilder() {
        }

        public VarScalingUniformFanAvgInitSchemeBuilder order(char order) {
            this.order = order;
            return this;
        }

        public VarScalingUniformFanAvgInitSchemeBuilder fanIn(double fanIn) {
            this.fanIn = fanIn;
            return this;
        }

        public VarScalingUniformFanAvgInitSchemeBuilder fanOut(double fanOut) {
            this.fanOut = fanOut;
            return this;
        }

        public VarScalingUniformFanAvgInitScheme build() {
            return new VarScalingUniformFanAvgInitScheme(this.order, this.fanIn, this.fanOut);
        }

        public String toString() {
            return "VarScalingUniformFanAvgInitScheme.VarScalingUniformFanAvgInitSchemeBuilder(order=" + this.order + ", fanIn=" + this.fanIn + ", fanOut=" + this.fanOut + ")";
        }
    }
}

